/*
 * Decompiled with CFR 0.152.
 */
package com.franmontiel.attributionpresenter;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.widget.ListAdapter;
import com.franmontiel.attributionpresenter.AttributionAdapter;
import com.franmontiel.attributionpresenter.R;
import com.franmontiel.attributionpresenter.entities.Attribution;
import com.franmontiel.attributionpresenter.entities.Library;
import com.franmontiel.attributionpresenter.listeners.OnAttributionClickListener;
import com.franmontiel.attributionpresenter.listeners.OnLicenseClickListener;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;

public final class AttributionPresenter {
    private Context context;
    private SortedSet<Attribution> attributions;
    private final int itemLayout;
    private final int licenseLayout;
    private OnAttributionClickListener onAttributionClickListener;
    private OnLicenseClickListener onLicenseClickListener;
    private AttributionAdapter attributionAdapter;

    private AttributionPresenter(Context context, SortedSet<Attribution> attributions, @LayoutRes int itemLayout, @LayoutRes int licenseLayout, @Nullable OnAttributionClickListener onAttributionClickListener, @Nullable OnLicenseClickListener onLicenseClickListener) {
        this.context = context;
        this.attributions = attributions;
        this.itemLayout = itemLayout == 0 ? R.layout.default_item_attribution : itemLayout;
        this.licenseLayout = licenseLayout == 0 ? R.layout.default_license_text : licenseLayout;
        this.onAttributionClickListener = onAttributionClickListener;
        this.onLicenseClickListener = onLicenseClickListener;
    }

    public Dialog showDialog(@Nullable String title) {
        return new AlertDialog.Builder(this.context).setTitle((CharSequence)title).setAdapter((ListAdapter)this.getAdapter(), null).show();
    }

    public AttributionAdapter getAdapter() {
        if (this.attributionAdapter == null) {
            this.attributionAdapter = new AttributionAdapter(this.attributions, this.itemLayout, this.licenseLayout, this.onAttributionClickListener, this.onLicenseClickListener);
        }
        return this.attributionAdapter;
    }

    public static class Builder {
        private Context context;
        private SortedSet<Attribution> attributions;
        @LayoutRes
        private int itemLayout;
        @LayoutRes
        private int licenseLayout;
        private OnAttributionClickListener onAttributionClickListener;
        private OnLicenseClickListener onLicenseClickListener;

        public Builder(Context context) {
            this.context = context;
            this.attributions = new TreeSet<Attribution>();
        }

        public Builder addAttributions(Attribution ... attributions) {
            this.attributions.addAll(Arrays.asList(attributions));
            return this;
        }

        public Builder addAttributions(Library ... libraries) {
            for (Library library : libraries) {
                this.attributions.add(library.getAttribution());
            }
            return this;
        }

        public Builder setItemLayout(@LayoutRes int itemLayoutResId) {
            this.itemLayout = itemLayoutResId;
            return this;
        }

        public Builder setLicenseLayout(@LayoutRes int licenseLayoutResId) {
            this.licenseLayout = licenseLayoutResId;
            return this;
        }

        public Builder setOnAttributionClickListener(OnAttributionClickListener onAttributionClickListener) {
            this.onAttributionClickListener = onAttributionClickListener;
            return this;
        }

        public Builder setOnLicenseClickListener(OnLicenseClickListener onLicenseClickListener) {
            this.onLicenseClickListener = onLicenseClickListener;
            return this;
        }

        public AttributionPresenter build() {
            return new AttributionPresenter(this.context, this.attributions, this.itemLayout, this.licenseLayout, this.onAttributionClickListener, this.onLicenseClickListener);
        }
    }
}

