/*
 * Decompiled with CFR 0.152.
 */
package com.framgia.android.emulator;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.framgia.android.emulator.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=14)
public final class EmulatorDetector {
    private static final String[] PHONE_NUMBERS = new String[]{"15555215554", "15555215556", "15555215558", "15555215560", "15555215562", "15555215564", "15555215566", "15555215568", "15555215570", "15555215572", "15555215574", "15555215576", "15555215578", "15555215580", "15555215582", "15555215584"};
    private static final String[] DEVICE_IDS = new String[]{"000000000000000", "e21833235b6eef10", "012345678912345"};
    private static final String[] IMSI_IDS = new String[]{"310260000000000"};
    private static final String[] GENY_FILES = new String[]{"/dev/socket/genyd", "/dev/socket/baseband_genyd"};
    private static final String[] QEMU_DRIVERS = new String[]{"goldfish"};
    private static final String[] PIPES = new String[]{"/dev/socket/qemud", "/dev/qemu_pipe"};
    private static final String[] X86_FILES = new String[]{"ueventd.android_x86.rc", "x86.prop", "ueventd.ttVM_x86.rc", "init.ttVM_x86.rc", "fstab.ttVM_x86", "fstab.vbox86", "init.vbox86.rc", "ueventd.vbox86.rc"};
    private static final String[] ANDY_FILES = new String[]{"fstab.andy", "ueventd.andy.rc"};
    private static final String[] NOX_FILES = new String[]{"fstab.nox", "init.nox.rc", "ueventd.nox.rc"};
    private static final Property[] PROPERTIES = new Property[]{new Property("init.svc.qemud", null), new Property("init.svc.qemu-props", null), new Property("qemu.hw.mainkeys", null), new Property("qemu.sf.fake_camera", null), new Property("qemu.sf.lcd_density", null), new Property("ro.bootloader", "unknown"), new Property("ro.bootmode", "unknown"), new Property("ro.hardware", "goldfish"), new Property("ro.kernel.android.qemud", null), new Property("ro.kernel.qemu.gles", null), new Property("ro.kernel.qemu", "1"), new Property("ro.product.device", "generic"), new Property("ro.product.model", "sdk"), new Property("ro.product.name", "sdk"), new Property("ro.serialno", null)};
    private static final String IP = "10.0.2.15";
    private static final int MIN_PROPERTIES_THRESHOLD = 5;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context mContext;
    private boolean isDebug = false;
    private boolean isTelephony = false;
    private List<String> mListPackageName = new ArrayList<String>();
    @SuppressLint(value={"StaticFieldLeak"})
    private static EmulatorDetector mEmulatorDetector;

    public static EmulatorDetector with(Context pContext) {
        if (mEmulatorDetector == null) {
            mEmulatorDetector = new EmulatorDetector(pContext);
        }
        return mEmulatorDetector;
    }

    private EmulatorDetector(Context pContext) {
        mContext = pContext;
        this.mListPackageName.add("com.google.android.launcher.layouts.genymotion");
        this.mListPackageName.add("com.bluestacks");
        this.mListPackageName.add("com.bignox.app");
    }

    public EmulatorDetector setDebug(boolean isDebug) {
        this.isDebug = isDebug;
        return this;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isCheckTelephony() {
        return this.isTelephony;
    }

    public EmulatorDetector setCheckTelephony(boolean telephony) {
        this.isTelephony = telephony;
        return this;
    }

    public EmulatorDetector addPackageName(String pPackageName) {
        this.mListPackageName.add(pPackageName);
        return this;
    }

    public EmulatorDetector addPackageName(List<String> pListPackageName) {
        this.mListPackageName.addAll(pListPackageName);
        return this;
    }

    public List<String> getPackageNameList() {
        return this.mListPackageName;
    }

    public void detect(final OnEmulatorDetectorListener pOnEmulatorDetectorListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean isEmulator = EmulatorDetector.this.detect();
                EmulatorDetector.this.log("This System is Emulator: " + isEmulator);
                if (pOnEmulatorDetectorListener != null) {
                    pOnEmulatorDetectorListener.onResult(isEmulator);
                }
            }
        }).start();
    }

    private boolean detect() {
        boolean result = false;
        this.log(EmulatorDetector.getDeviceInfo());
        if (!result) {
            result = this.checkBasic();
            this.log("Check basic " + result);
        }
        if (!result) {
            result = this.checkAdvanced();
            this.log("Check Advanced " + result);
        }
        if (!result) {
            result = this.checkPackageName();
            this.log("Check Package Name " + result);
        }
        return result;
    }

    private boolean checkBasic() {
        boolean result;
        boolean bl = result = Build.FINGERPRINT.startsWith("generic") || Build.MODEL.contains("google_sdk") || Build.MODEL.toLowerCase().contains("droid4x") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.HARDWARE.equals("goldfish") || Build.HARDWARE.equals("vbox86") || Build.PRODUCT.equals("sdk") || Build.PRODUCT.equals("google_sdk") || Build.PRODUCT.equals("sdk_x86") || Build.PRODUCT.equals("vbox86p") || Build.BOARD.toLowerCase().contains("nox") || Build.BOOTLOADER.toLowerCase().contains("nox") || Build.HARDWARE.toLowerCase().contains("nox") || Build.PRODUCT.toLowerCase().contains("nox") || Build.SERIAL.toLowerCase().contains("nox");
        if (result) {
            return true;
        }
        if (result |= Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic")) {
            return true;
        }
        return result |= "google_sdk".equals(Build.PRODUCT);
    }

    private boolean checkAdvanced() {
        boolean result = this.checkTelephony() || this.checkFiles(GENY_FILES, "Geny") || this.checkFiles(ANDY_FILES, "Andy") || this.checkFiles(NOX_FILES, "Nox") || this.checkQEmuDrivers() || this.checkFiles(PIPES, "Pipes") || this.checkIp() || this.checkQEmuProps() && this.checkFiles(X86_FILES, "X86");
        return result;
    }

    private boolean checkPackageName() {
        PackageManager packageManager = mContext.getPackageManager();
        List packages = packageManager.getInstalledApplications(128);
        for (ApplicationInfo packageInfo : packages) {
            String packageName = packageInfo.packageName;
            boolean isEmulator = this.mListPackageName.contains(packageName);
            if (!isEmulator) continue;
            this.log("Detected " + packageName);
            return true;
        }
        return false;
    }

    private boolean checkTelephony() {
        if (ContextCompat.checkSelfPermission((Context)mContext, (String)"android.permission.READ_PHONE_STATE") == 0 && this.isTelephony && this.isSupportTelePhony()) {
            return this.checkPhoneNumber() || this.checkDeviceId() || this.checkImsi() || this.checkOperatorNameAndroid();
        }
        return false;
    }

    private boolean checkPhoneNumber() {
        TelephonyManager telephonyManager = (TelephonyManager)mContext.getSystemService("phone");
        String phoneNumber = telephonyManager.getLine1Number();
        for (String number : PHONE_NUMBERS) {
            if (!number.equalsIgnoreCase(phoneNumber)) continue;
            this.log(" check phone number is detected");
            return true;
        }
        return false;
    }

    private boolean checkDeviceId() {
        TelephonyManager telephonyManager = (TelephonyManager)mContext.getSystemService("phone");
        String deviceId = telephonyManager.getDeviceId();
        for (String known_deviceId : DEVICE_IDS) {
            if (!known_deviceId.equalsIgnoreCase(deviceId)) continue;
            this.log("Check device id is detected");
            return true;
        }
        return false;
    }

    private boolean checkImsi() {
        TelephonyManager telephonyManager = (TelephonyManager)mContext.getSystemService("phone");
        String imsi = telephonyManager.getSubscriberId();
        for (String known_imsi : IMSI_IDS) {
            if (!known_imsi.equalsIgnoreCase(imsi)) continue;
            this.log("Check imsi is detected");
            return true;
        }
        return false;
    }

    private boolean checkOperatorNameAndroid() {
        String operatorName = ((TelephonyManager)mContext.getSystemService("phone")).getNetworkOperatorName();
        if (operatorName.equalsIgnoreCase("android")) {
            this.log("Check operator name android is detected");
            return true;
        }
        return false;
    }

    private boolean checkQEmuDrivers() {
        for (File drivers_file : new File[]{new File("/proc/tty/drivers"), new File("/proc/cpuinfo")}) {
            if (!drivers_file.exists() || !drivers_file.canRead()) continue;
            byte[] data = new byte[1024];
            try {
                FileInputStream is = new FileInputStream(drivers_file);
                ((InputStream)is).read(data);
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String driver_data = new String(data);
            for (String known_qemu_driver : QEMU_DRIVERS) {
                if (!driver_data.contains(known_qemu_driver)) continue;
                this.log("Check QEmuDrivers is detected");
                return true;
            }
        }
        return false;
    }

    private boolean checkFiles(String[] targets, String type) {
        for (String pipe : targets) {
            File qemu_file = new File(pipe);
            if (!qemu_file.exists()) continue;
            this.log("Check " + type + " is detected");
            return true;
        }
        return false;
    }

    private boolean checkQEmuProps() {
        int found_props = 0;
        for (Property property : PROPERTIES) {
            String property_value = this.getProp(mContext, property.name);
            if (property.seek_value == null && property_value != null) {
                ++found_props;
            }
            if (property.seek_value == null || !property_value.contains(property.seek_value)) continue;
            ++found_props;
        }
        if (found_props >= 5) {
            this.log("Check QEmuProps is detected");
            return true;
        }
        return false;
    }

    private boolean checkIp() {
        boolean ipDetected = false;
        if (ContextCompat.checkSelfPermission((Context)mContext, (String)"android.permission.INTERNET") == 0) {
            String[] args = new String[]{"/system/bin/netcfg"};
            StringBuilder stringBuilder = new StringBuilder();
            try {
                ProcessBuilder builder = new ProcessBuilder(args);
                builder.directory(new File("/system/bin/"));
                builder.redirectErrorStream(true);
                Process process = builder.start();
                InputStream in = process.getInputStream();
                byte[] re = new byte[1024];
                while (in.read(re) != -1) {
                    stringBuilder.append(new String(re));
                }
                in.close();
            }
            catch (Exception builder) {
                // empty catch block
            }
            String netData = stringBuilder.toString();
            this.log("netcfg data -> " + netData);
            if (!TextUtils.isEmpty((CharSequence)netData)) {
                String[] array;
                for (String lan : array = netData.split("\n")) {
                    if (!lan.contains("wlan0") && !lan.contains("tunl0") && !lan.contains("eth0") || !lan.contains(IP)) continue;
                    ipDetected = true;
                    this.log("Check IP is detected");
                    break;
                }
            }
        }
        return ipDetected;
    }

    private String getProp(Context context, String property) {
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> systemProperties = classLoader.loadClass("android.os.SystemProperties");
            Method get = systemProperties.getMethod("get", String.class);
            Object[] params = new Object[]{property};
            return (String)get.invoke(systemProperties, params);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isSupportTelePhony() {
        PackageManager packageManager = mContext.getPackageManager();
        boolean isSupport = packageManager.hasSystemFeature("android.hardware.telephony");
        this.log("Supported TelePhony: " + isSupport);
        return isSupport;
    }

    private void log(String str) {
        if (this.isDebug) {
            Log.d((String)this.getClass().getName(), (String)str);
        }
    }

    public static String getDeviceInfo() {
        return "Build.PRODUCT: " + Build.PRODUCT + "\nBuild.MANUFACTURER: " + Build.MANUFACTURER + "\nBuild.BRAND: " + Build.BRAND + "\nBuild.DEVICE: " + Build.DEVICE + "\nBuild.MODEL: " + Build.MODEL + "\nBuild.HARDWARE: " + Build.HARDWARE + "\nBuild.FINGERPRINT: " + Build.FINGERPRINT;
    }

    public static interface OnEmulatorDetectorListener {
        public void onResult(boolean var1);
    }
}

