/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.plaf.metal;

import java.awt.Dimension;
import javax.swing.JLabel;

final class AlignedLabel
extends JLabel {
    protected AlignedLabel[] group;
    private int maxWidth = 0;

    public AlignedLabel() {
        this.setAlignmentX(0.0f);
    }

    public AlignedLabel(String text) {
        super(text);
        this.setAlignmentX(0.0f);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(this.getMaxWidth() + 11, d.height);
    }

    private int getMaxWidth() {
        if (this.maxWidth == 0 && this.group != null) {
            int max = 0;
            for (AlignedLabel grp : this.group) {
                max = Math.max(grp.getSuperPreferredWidth(), max);
            }
            for (AlignedLabel grp : this.group) {
                grp.maxWidth = max;
            }
        }
        return this.maxWidth;
    }

    private int getSuperPreferredWidth() {
        return super.getPreferredSize().width;
    }
}

