/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.accessories.bookmarks;

import com.googlecode.vfsjfilechooser2.accessories.bookmarks.Bookmarks;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.TitledURLEntry;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

final class BookmarksReader {
    private List<TitledURLEntry> entries;
    private Logger logger;

    public BookmarksReader(File bookmarksFile) {
        block16: {
            this.logger = Logger.getLogger(Bookmarks.class.getName());
            this.entries = new ArrayList<TitledURLEntry>();
            Reader reader = null;
            try {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                xmlReader.setContentHandler(new BookmarksHandler());
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bookmarksFile), "UTF-8"));
                char[] code = new char[2];
                reader.read(code, 0, 2);
                this.logger.log(Level.FINEST, "code=" + String.valueOf(code) + "=");
                if (code[0] == 'b' && code[1] == '1') {
                    this.logger.log(Level.FINEST, "in encrypted code section");
                    FileInputStream is = new FileInputStream(bookmarksFile);
                    int the_length = (int)bookmarksFile.length() - 2;
                    this.logger.log(Level.FINEST, "raw_length=" + (the_length + 2));
                    if (the_length <= 0) {
                        the_length = 1;
                    }
                    this.logger.log(Level.FINEST, "fixed_length=" + the_length);
                    byte[] code2 = new byte[2];
                    byte[] outhex = new byte[the_length];
                    try {
                        ((InputStream)is).read(code2);
                        ((InputStream)is).read(outhex);
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        this.logger.log(Level.INFO, "exception reading encrypted file" + e);
                    }
                    byte[] out = Util.hexByteArrayToByteArray(outhex);
                    byte[] raw = new byte[16];
                    raw[0] = 1;
                    raw[2] = 23;
                    raw[3] = 24;
                    raw[4] = 2;
                    raw[5] = 99;
                    raw[6] = -56;
                    raw[7] = -54;
                    raw[8] = -47;
                    raw[9] = -57;
                    raw[10] = -75;
                    raw[11] = -1;
                    raw[12] = 33;
                    raw[13] = -46;
                    raw[14] = -42;
                    raw[15] = -40;
                    SecretKeySpec skeyspec = new SecretKeySpec(raw, "Blowfish");
                    Cipher cipher = Cipher.getInstance("Blowfish");
                    cipher.init(2, skeyspec);
                    byte[] decrypted = cipher.doFinal(out);
                    ByteArrayInputStream bstream = new ByteArrayInputStream(decrypted);
                    InputSource inputSource = new InputSource(bstream);
                    xmlReader.parse(inputSource);
                    this.logger.log(Level.FINEST, "leaving encrypted code section");
                    break block16;
                }
                this.logger.log(Level.FINEST, "in decrypted code section");
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bookmarksFile), "UTF-8"));
                InputSource inputSource = new InputSource(reader);
                xmlReader.parse(inputSource);
                this.logger.log(Level.FINEST, "leaving decrypted code section");
            }
            catch (SAXParseException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Error parsing xml bookmarks file").append("\n").append(e.getLineNumber()).append(":").append(e.getColumnNumber()).append("\n").append(e.getMessage());
                throw new RuntimeException(sb.toString(), e);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Bookmarks file doesn't exist!", e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        this.logger.log(Level.WARNING, "Unable to close bookmarks stream", ioe);
                    }
                }
            }
        }
    }

    public List<TitledURLEntry> getParsedEntries() {
        return this.entries;
    }

    private class BookmarksHandler
    implements ContentHandler {
        private BookmarksHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("entry".equals(localName)) {
                TitledURLEntry tue = null;
                String title = atts.getValue("title");
                String url = atts.getValue("url");
                if (title != null && url != null) {
                    tue = new TitledURLEntry(title, url);
                    BookmarksReader.this.entries.add(tue);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }
}

