/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import weka.core.Drawable;
import weka.core.Instances;
import weka.core.SerializationHelper;
import weka.gui.ComponentHelper;
import weka.gui.ExtensionFileFilter;
import weka.gui.Logger;
import weka.gui.SysErrLog;
import weka.gui.explorer.Explorer;

public class SerializedModelViewerPanel
extends JPanel
implements Explorer.ExplorerPanel,
Explorer.LogHandler {
    private static final long serialVersionUID = 2078066653508312179L;
    protected Explorer m_Explorer = null;
    protected Logger m_Log = new SysErrLog();
    protected JFileChooser m_FileChooserModel;
    protected JFileChooser m_FileChooserContent;
    protected JTextField m_TextFile;
    protected JButton m_ButtonFile;
    protected JTabbedPane m_TabbedPane;

    public SerializedModelViewerPanel() {
        this.initialize();
        this.initGUI();
    }

    protected void initialize() {
        this.m_FileChooserModel = new JFileChooser();
        this.m_FileChooserModel.setFileSelectionMode(0);
        this.m_FileChooserModel.setMultiSelectionEnabled(false);
        ExtensionFileFilter filter = new ExtensionFileFilter(new String[]{"model", "ser"}, "Serialized model files (*.model, *.ser)");
        this.m_FileChooserModel.addChoosableFileFilter((FileFilter)filter);
        this.m_FileChooserModel.setAcceptAllFileFilterUsed(true);
        this.m_FileChooserModel.setFileFilter((FileFilter)filter);
        this.m_FileChooserContent = new JFileChooser();
        filter = new ExtensionFileFilter(new String[]{"txt"}, "Text files (*.txt)");
        this.m_FileChooserContent.setFileSelectionMode(0);
        this.m_FileChooserContent.addChoosableFileFilter((FileFilter)filter);
        this.m_FileChooserContent.setAcceptAllFileFilterUsed(true);
        this.m_FileChooserContent.setFileFilter((FileFilter)filter);
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add((Component)panel, "North");
        this.m_TextFile = new JTextField(30);
        this.m_TextFile.setEditable(false);
        this.m_ButtonFile = new JButton("...");
        this.m_ButtonFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerializedModelViewerPanel.this.loadFile();
            }
        });
        JLabel label = new JLabel("Model");
        label.setDisplayedMnemonic('M');
        label.setLabelFor(this.m_ButtonFile);
        panel.add(label);
        panel.add(this.m_TextFile);
        panel.add(this.m_ButtonFile);
        this.m_TabbedPane = new JTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
    }

    protected JTextArea newTextArea() {
        final JTextArea result = new JTextArea(20, 80);
        result.setEditable(false);
        result.setFont(new Font("monospaced", 0, 12));
        result.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SerializedModelViewerPanel.this.isRightClick(e)) {
                    e.consume();
                    SerializedModelViewerPanel.this.showPopup(result, e);
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        return result;
    }

    protected JScrollPane newScrollPane(JComponent comp) {
        JScrollPane result = new JScrollPane(comp);
        result.getHorizontalScrollBar().setBlockIncrement(20);
        result.getHorizontalScrollBar().setUnitIncrement(20);
        result.getVerticalScrollBar().setBlockIncrement(20);
        result.getVerticalScrollBar().setUnitIncrement(20);
        return result;
    }

    protected boolean isRightClick(MouseEvent e) {
        int modifiers = e.getModifiers();
        if ((modifiers & 1) == 1 && (modifiers & 8) == 8 && (modifiers & 0x10) == 16) {
            return true;
        }
        return (modifiers & 4) == 4;
    }

    protected void showPopup(final JTextArea textArea, MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy", ComponentHelper.getImageIcon((String)"copy.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerializedModelViewerPanel.this.copyContent(textArea);
            }
        });
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JMenuItem("Save...", ComponentHelper.getImageIcon((String)"save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerializedModelViewerPanel.this.saveContent(textArea);
            }
        });
        menu.add(menuitem);
        menu.show(textArea, e.getX(), e.getY());
    }

    protected boolean loadFile() {
        int retVal = this.m_FileChooserModel.showOpenDialog(this);
        if (retVal != 0) {
            return false;
        }
        return this.loadFile(this.m_FileChooserModel.getSelectedFile());
    }

    protected boolean loadFile(File file) {
        while (this.m_TabbedPane.getTabCount() > 0) {
            this.m_TabbedPane.removeTabAt(0);
        }
        try {
            Object[] objects = SerializationHelper.readAll((String)file.getAbsolutePath());
            for (int i = 0; i < objects.length; ++i) {
                StringBuilder content = new StringBuilder();
                content.append(objects[i].getClass().getName()).append("\n");
                content.append("\n");
                content.append("" + objects[i]);
                content.append("\n");
                JTextArea m_TextContent = this.newTextArea();
                m_TextContent.setText(content.toString());
                this.m_TabbedPane.addTab(objects[i].getClass().getSimpleName(), this.newScrollPane(m_TextContent));
                if (!(objects[i] instanceof Drawable)) continue;
                try {
                    String graph = ((Drawable)objects[i]).graph();
                    content = new StringBuilder();
                    content.append(graph);
                    content.append("\n");
                    m_TextContent = this.newTextArea();
                    m_TextContent.setText(content.toString());
                    this.m_TabbedPane.addTab(objects[i].getClass().getSimpleName() + " (graph)", this.newScrollPane(m_TextContent));
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Failed to obtain graph from: " + file + "/" + objects[i].getClass().getName());
                    e.printStackTrace();
                }
            }
            this.m_TextFile.setText("" + file);
            if (this.m_TabbedPane.getTabCount() > 0) {
                this.m_TabbedPane.setSelectedIndex(0);
            }
            return true;
        }
        catch (Exception e) {
            this.showErrorMessage("Error loading model file", "Failed to load model file: " + file, e);
            return false;
        }
    }

    protected void copyContent(JTextArea textArea) {
        String content = textArea.getSelectedText() == null ? textArea.getText() : textArea.getSelectedText();
        StringSelection selection = new StringSelection(content);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveContent(JTextArea textArea) {
        int retVal = this.m_FileChooserContent.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        String content = textArea.getSelectedText() == null ? textArea.getText() : textArea.getSelectedText();
        File file = this.m_FileChooserContent.getSelectedFile();
        FileWriter fwriter = null;
        BufferedWriter bwriter = null;
        try {
            fwriter = new FileWriter(file);
            bwriter = new BufferedWriter(fwriter);
            bwriter.write(content);
            bwriter.flush();
        }
        catch (Exception e) {
            this.showErrorMessage("Error writing content", "Failed to write content to " + file, e);
        }
        finally {
            if (bwriter != null) {
                try {
                    bwriter.flush();
                    bwriter.close();
                }
                catch (Exception exception) {}
            }
            if (fwriter != null) {
                try {
                    fwriter.flush();
                    fwriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    protected void showErrorMessage(String title, String msg, Exception e) {
        System.err.println(msg);
        e.printStackTrace();
        msg = msg + "\n" + e;
        this.m_Log.logMessage(msg);
        JOptionPane.showMessageDialog(this, msg, title, 0);
    }

    public void setInstances(Instances inst) {
    }

    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        return "Model viewer";
    }

    public String getTabTitleToolTip() {
        return "Allows viewing of serialized models, outputting their string representation.";
    }
}

