/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.rsync4j.core;

import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import com.github.fracpete.processoutput4j.output.ConsoleOutputProcessOutput;
import com.github.fracpete.rsync4j.core.Utils;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public abstract class AbstractBinary {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    protected boolean outputCommandline;

    public AbstractBinary() {
        this.reset();
    }

    public void reset() {
        this.outputCommandline = false;
    }

    public AbstractBinary outputCommandline(boolean value) {
        this.outputCommandline = value;
        return this;
    }

    public boolean getOutputCommandline() {
        return this.outputCommandline;
    }

    public abstract List<String> options() throws Exception;

    public abstract List<String> commandLineArgs() throws Exception;

    public ProcessBuilder builder() throws Exception {
        List<String> args = this.commandLineArgs();
        if (this.getOutputCommandline()) {
            this.logger.info("Command-line: " + Utils.flatten(args, " "));
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(args);
        return builder;
    }

    public Process start() throws Exception {
        return this.builder().start();
    }

    public CollectingProcessOutput execute() throws Exception {
        CollectingProcessOutput result = new CollectingProcessOutput();
        result.monitor(this.builder());
        return result;
    }

    protected abstract String description();

    protected ArgumentParser getParser() {
        ArgumentParser parser = ArgumentParsers.newFor((String)this.getClass().getName()).build();
        parser.description(this.description());
        parser.addArgument(new String[]{"--output-commandline"}).setDefault((Object)false).dest("outputCommandline").help("output the command-line generated for the wrapped binary").action((ArgumentAction)Arguments.storeTrue());
        return parser;
    }

    protected boolean setOptions(Namespace ns) {
        this.outputCommandline((Boolean)ns.get("outputCommandline"));
        return true;
    }

    public boolean setOptions(String[] options) throws Exception {
        Namespace ns;
        ArgumentParser parser = this.getParser();
        try {
            ns = parser.parseArgs(options);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return false;
        }
        return this.setOptions(ns);
    }

    public static void run(AbstractBinary binary, String[] args) throws Exception {
        if (binary.setOptions(args)) {
            ConsoleOutputProcessOutput output = new ConsoleOutputProcessOutput();
            output.monitor(binary.builder());
        } else {
            System.exit(1);
        }
    }
}

