/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.wave;

import com.musicg.api.WhistleApi;
import com.musicg.wave.Wave;
import com.musicg.wave.WaveHeader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class WaveTypeDetector {
    private Wave wave;

    public WaveTypeDetector(Wave wave) {
        this.wave = wave;
    }

    public double getWhistleProbability() {
        double probability = 0.0;
        WaveHeader wavHeader = this.wave.getWaveHeader();
        int fftSampleSize = 1024;
        int fftSignalByteLength = fftSampleSize * wavHeader.getBitsPerSample() / 8;
        byte[] audioBytes = this.wave.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(audioBytes);
        WhistleApi whistleApi = new WhistleApi(wavHeader);
        try {
            boolean isWhistle;
            int frameNumber;
            int numFrames = inputStream.available() / fftSignalByteLength;
            byte[] bytes = new byte[fftSignalByteLength];
            int checkLength = 3;
            int passScore = 3;
            ArrayList<Boolean> bufferList = new ArrayList<Boolean>();
            int numWhistles = 0;
            int numPasses = 0;
            for (frameNumber = 0; frameNumber < checkLength; ++frameNumber) {
                inputStream.read(bytes);
                isWhistle = whistleApi.isWhistle(bytes);
                bufferList.add(isWhistle);
                if (isWhistle) {
                    ++numWhistles;
                }
                if (numWhistles < passScore) continue;
                ++numPasses;
            }
            for (frameNumber = checkLength; frameNumber < numFrames; ++frameNumber) {
                inputStream.read(bytes);
                isWhistle = whistleApi.isWhistle(bytes);
                if (((Boolean)bufferList.get(0)).booleanValue()) {
                    --numWhistles;
                }
                bufferList.remove(0);
                bufferList.add(isWhistle);
                if (isWhistle) {
                    ++numWhistles;
                }
                if (numWhistles < passScore) continue;
                ++numPasses;
            }
            probability = (double)numPasses / (double)numFrames;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return probability;
    }
}

