/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.wave;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class WaveHeader
implements Serializable,
Cloneable {
    public static final String RIFF_HEADER = "RIFF";
    public static final String WAVE_HEADER = "WAVE";
    public static final String FMT_HEADER = "fmt ";
    public static final String DATA_HEADER = "data";
    public static final int HEADER_BYTE_LENGTH = 44;
    private boolean valid;
    private String chunkId;
    private long chunkSize;
    private String format;
    private String subChunk1Id;
    private long subChunk1Size;
    private int audioFormat;
    private int channels;
    private long sampleRate;
    private long byteRate;
    private int blockAlign;
    private int bitsPerSample;
    private String subChunk2Id;
    private long subChunk2Size;

    public WaveHeader() {
        this.chunkSize = 36L;
        this.subChunk1Size = 16L;
        this.audioFormat = 1;
        this.channels = 1;
        this.sampleRate = 8000L;
        this.byteRate = 16000L;
        this.blockAlign = 2;
        this.bitsPerSample = 16;
        this.subChunk2Size = 0L;
        this.valid = true;
    }

    public WaveHeader(InputStream inputStream) {
        this.valid = this.loadHeader(inputStream);
    }

    private boolean loadHeader(InputStream inputStream) {
        byte[] headerBuffer = new byte[44];
        try {
            inputStream.read(headerBuffer);
            int pointer = 0;
            this.chunkId = new String(new byte[]{headerBuffer[pointer++], headerBuffer[pointer++], headerBuffer[pointer++], headerBuffer[pointer++]});
            this.chunkSize = (long)(headerBuffer[pointer++] & 0xFF) | (long)(headerBuffer[pointer++] & 0xFF) << 8 | (long)(headerBuffer[pointer++] & 0xFF) << 16 | (long)(headerBuffer[pointer++] & 0xFF000000);
            this.format = new String(new byte[]{headerBuffer[pointer++], headerBuffer[pointer++], headerBuffer[pointer++], headerBuffer[pointer++]});
            this.subChunk1Id = new String(new byte[]{headerBuffer[pointer++], headerBuffer[pointer++], headerBuffer[pointer++], headerBuffer[pointer++]});
            this.subChunk1Size = (long)(headerBuffer[pointer++] & 0xFF) | (long)(headerBuffer[pointer++] & 0xFF) << 8 | (long)(headerBuffer[pointer++] & 0xFF) << 16 | (long)(headerBuffer[pointer++] & 0xFF) << 24;
            this.audioFormat = headerBuffer[pointer++] & 0xFF | (headerBuffer[pointer++] & 0xFF) << 8;
            this.channels = headerBuffer[pointer++] & 0xFF | (headerBuffer[pointer++] & 0xFF) << 8;
            this.sampleRate = (long)(headerBuffer[pointer++] & 0xFF) | (long)(headerBuffer[pointer++] & 0xFF) << 8 | (long)(headerBuffer[pointer++] & 0xFF) << 16 | (long)(headerBuffer[pointer++] & 0xFF) << 24;
            this.byteRate = (long)(headerBuffer[pointer++] & 0xFF) | (long)(headerBuffer[pointer++] & 0xFF) << 8 | (long)(headerBuffer[pointer++] & 0xFF) << 16 | (long)(headerBuffer[pointer++] & 0xFF) << 24;
            this.blockAlign = headerBuffer[pointer++] & 0xFF | (headerBuffer[pointer++] & 0xFF) << 8;
            this.bitsPerSample = headerBuffer[pointer++] & 0xFF | (headerBuffer[pointer++] & 0xFF) << 8;
            this.subChunk2Id = new String(new byte[]{headerBuffer[pointer++], headerBuffer[pointer++], headerBuffer[pointer++], headerBuffer[pointer++]});
            this.subChunk2Size = (long)(headerBuffer[pointer++] & 0xFF) | (long)(headerBuffer[pointer++] & 0xFF) << 8 | (long)(headerBuffer[pointer++] & 0xFF) << 16 | (long)(headerBuffer[pointer++] & 0xFF) << 24;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (this.bitsPerSample != 8 && this.bitsPerSample != 16) {
            System.err.println("WaveHeader: only supports bitsPerSample 8 or 16");
            return false;
        }
        if (this.chunkId.toUpperCase().equals(RIFF_HEADER) && this.format.toUpperCase().equals(WAVE_HEADER) && this.audioFormat == 1) {
            return true;
        }
        System.err.println("WaveHeader: Unsupported header format");
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getChunkId() {
        return this.chunkId;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public String getFormat() {
        return this.format;
    }

    public String getSubChunk1Id() {
        return this.subChunk1Id;
    }

    public long getSubChunk1Size() {
        return this.subChunk1Size;
    }

    public int getAudioFormat() {
        return this.audioFormat;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSampleRate() {
        return (int)this.sampleRate;
    }

    public int getByteRate() {
        return (int)this.byteRate;
    }

    public int getBlockAlign() {
        return this.blockAlign;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public String getSubChunk2Id() {
        return this.subChunk2Id;
    }

    public long getSubChunk2Size() {
        return this.subChunk2Size;
    }

    public void setSampleRate(int sampleRate) {
        int newSubChunk2Size = (int)(this.subChunk2Size * (long)sampleRate / this.sampleRate);
        if (this.bitsPerSample / 8 % 2 == 0 && newSubChunk2Size % 2 != 0) {
            ++newSubChunk2Size;
        }
        this.sampleRate = sampleRate;
        this.byteRate = sampleRate * this.bitsPerSample / 8;
        this.chunkSize = newSubChunk2Size + 36;
        this.subChunk2Size = newSubChunk2Size;
    }

    public void setChunkId(String chunkId) {
        this.chunkId = chunkId;
    }

    public void setChunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSubChunk1Id(String subChunk1Id) {
        this.subChunk1Id = subChunk1Id;
    }

    public void setSubChunk1Size(long subChunk1Size) {
        this.subChunk1Size = subChunk1Size;
    }

    public void setAudioFormat(int audioFormat) {
        this.audioFormat = audioFormat;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public void setByteRate(long byteRate) {
        this.byteRate = byteRate;
    }

    public void setBlockAlign(int blockAlign) {
        this.blockAlign = blockAlign;
    }

    public void setBitsPerSample(int bitsPerSample) {
        this.bitsPerSample = bitsPerSample;
    }

    public void setSubChunk2Id(String subChunk2Id) {
        this.subChunk2Id = subChunk2Id;
    }

    public void setSubChunk2Size(long subChunk2Size) {
        this.subChunk2Size = subChunk2Size;
    }

    public WaveHeader clone() {
        WaveHeader result = new WaveHeader();
        result.valid = this.valid;
        result.chunkId = this.chunkId;
        result.chunkSize = this.chunkSize;
        result.format = this.format;
        result.subChunk1Id = this.subChunk1Id;
        result.subChunk1Size = this.subChunk1Size;
        result.audioFormat = this.audioFormat;
        result.channels = this.channels;
        result.sampleRate = this.sampleRate;
        result.byteRate = this.byteRate;
        result.blockAlign = this.blockAlign;
        result.bitsPerSample = this.bitsPerSample;
        result.subChunk2Id = this.subChunk2Id;
        result.subChunk2Size = this.subChunk2Size;
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("chunkId: " + this.chunkId);
        sb.append("\n");
        sb.append("chunkSize: " + this.chunkSize);
        sb.append("\n");
        sb.append("format: " + this.format);
        sb.append("\n");
        sb.append("subChunk1Id: " + this.subChunk1Id);
        sb.append("\n");
        sb.append("subChunk1Size: " + this.subChunk1Size);
        sb.append("\n");
        sb.append("audioFormat: " + this.audioFormat);
        sb.append("\n");
        sb.append("channels: " + this.channels);
        sb.append("\n");
        sb.append("sampleRate: " + this.sampleRate);
        sb.append("\n");
        sb.append("byteRate: " + this.byteRate);
        sb.append("\n");
        sb.append("blockAlign: " + this.blockAlign);
        sb.append("\n");
        sb.append("bitsPerSample: " + this.bitsPerSample);
        sb.append("\n");
        sb.append("subChunk2Id: " + this.subChunk2Id);
        sb.append("\n");
        sb.append("subChunk2Size: " + this.subChunk2Size);
        return sb.toString();
    }
}

