/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.math.rank;

import com.musicg.math.rank.MapRank;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapRankDouble
implements MapRank {
    private Map map;
    private boolean acsending = true;

    public MapRankDouble(Map<?, Double> map, boolean acsending) {
        this.map = map;
        this.acsending = acsending;
    }

    @Override
    public List getOrderedKeyList(int numKeys, boolean sharpLimit) {
        LinkedList keyList;
        block7: {
            Set mapEntrySet = this.map.entrySet();
            keyList = new LinkedList();
            if (numKeys > this.map.size()) {
                numKeys = this.map.size();
            }
            if (this.map.size() <= 0) break block7;
            double[] array = new double[this.map.size()];
            int count = 0;
            for (Map.Entry entry : mapEntrySet) {
                array[count++] = (Double)entry.getValue();
            }
            int targetindex = this.acsending ? numKeys : array.length - numKeys;
            double passValue = this.getOrderedValue(array, targetindex);
            HashMap passedMap = new HashMap();
            LinkedList<Double> valueList = new LinkedList<Double>();
            for (Map.Entry entry : mapEntrySet) {
                double value = (Double)entry.getValue();
                if (!(this.acsending && value <= passValue) && (this.acsending || !(value >= passValue))) continue;
                passedMap.put(entry.getKey(), value);
                valueList.add(value);
            }
            Object[] listArr = new Double[valueList.size()];
            valueList.toArray(listArr);
            Arrays.sort(listArr);
            int resultCount = 0;
            int index = this.acsending ? 0 : listArr.length - 1;
            if (!sharpLimit) {
                numKeys = listArr.length;
            }
            do {
                double targetValue = (Double)listArr[index];
                Iterator passedMapIterator = passedMap.entrySet().iterator();
                while (passedMapIterator.hasNext()) {
                    Map.Entry entry = passedMapIterator.next();
                    if ((Double)entry.getValue() != targetValue) continue;
                    keyList.add(entry.getKey());
                    passedMapIterator.remove();
                    ++resultCount;
                    break;
                }
                if (this.acsending) {
                    ++index;
                    continue;
                }
                --index;
            } while (resultCount < numKeys);
        }
        return keyList;
    }

    private double getOrderedValue(double[] array, int index) {
        this.locate(array, 0, array.length - 1, index);
        return array[index];
    }

    private void locate(double[] array, int left, int right, int index) {
        int mid = (left + right) / 2;
        if (right == left) {
            return;
        }
        if (left < right) {
            double s = array[mid];
            int i = left - 1;
            int j = right + 1;
            while (true) {
                if (array[++i] < s) {
                    continue;
                }
                while (array[--j] > s) {
                }
                if (i >= j) break;
                this.swap(array, i, j);
            }
            if (i > index) {
                this.locate(array, left, i - 1, index);
            } else {
                this.locate(array, j + 1, right, index);
            }
        }
    }

    private void swap(double[] array, int i, int j) {
        double t = array[i];
        array[i] = array[j];
        array[j] = t;
    }
}

