/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.math.quicksort;

import com.musicg.math.quicksort.QuickSort;

public class QuickSortInteger
extends QuickSort {
    private int[] indexes;
    private int[] array;

    public QuickSortInteger(int[] array) {
        this.array = array;
        this.indexes = new int[array.length];
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = i;
        }
    }

    @Override
    public int[] getSortIndexes() {
        this.sort();
        return this.indexes;
    }

    private void sort() {
        this.quicksort(this.array, this.indexes, 0, this.indexes.length - 1);
    }

    private void quicksort(int[] a, int[] indexes, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = this.partition(a, indexes, left, right);
        this.quicksort(a, indexes, left, i - 1);
        this.quicksort(a, indexes, i + 1, right);
    }

    private int partition(int[] a, int[] indexes, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[indexes[++i]] < a[indexes[right]]) {
                continue;
            }
            while (a[indexes[right]] < a[indexes[--j]] && j != left) {
            }
            if (i >= j) break;
            this.swap(a, indexes, i, j);
        }
        this.swap(a, indexes, i, right);
        return i;
    }

    private void swap(int[] a, int[] indexes, int i, int j) {
        int swap = indexes[i];
        indexes[i] = indexes[j];
        indexes[j] = swap;
    }
}

