/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.fingerprint;

import com.musicg.dsp.Resampler;
import com.musicg.processor.TopManyPointsProcessorChain;
import com.musicg.properties.FingerprintProperties;
import com.musicg.wave.Wave;
import com.musicg.wave.WaveHeader;
import com.musicg.wave.extension.Spectrogram;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FingerprintManager {
    private FingerprintProperties fingerprintProperties = FingerprintProperties.getInstance();
    private int sampleSizePerFrame = this.fingerprintProperties.getSampleSizePerFrame();
    private int overlapFactor = this.fingerprintProperties.getOverlapFactor();
    private int numRobustPointsPerFrame = this.fingerprintProperties.getNumRobustPointsPerFrame();
    private int numFilterBanks = this.fingerprintProperties.getNumFilterBanks();

    public byte[] extractFingerprint(Wave wave) {
        byte[] fingerprint = new byte[]{};
        Resampler resampler = new Resampler();
        int sourceRate = wave.getWaveHeader().getSampleRate();
        int targetRate = this.fingerprintProperties.getSampleRate();
        byte[] resampledWaveData = resampler.reSample(wave.getBytes(), wave.getWaveHeader().getBitsPerSample(), sourceRate, targetRate);
        WaveHeader resampledWaveHeader = wave.getWaveHeader();
        resampledWaveHeader.setSampleRate(targetRate);
        Wave resampledWave = new Wave(resampledWaveHeader, resampledWaveData);
        Spectrogram spectrogram = resampledWave.getSpectrogram(this.sampleSizePerFrame, this.overlapFactor);
        double[][] spectorgramData = spectrogram.getNormalizedSpectrogramData();
        List<Integer>[] pointsLists = this.getRobustPointList(spectorgramData);
        int numFrames = pointsLists.length;
        int[][] coordinates = new int[numFrames][this.numRobustPointsPerFrame];
        for (int x = 0; x < numFrames; ++x) {
            if (pointsLists[x].size() == this.numRobustPointsPerFrame) {
                Iterator<Integer> pointsListsIterator = pointsLists[x].iterator();
                for (int y = 0; y < this.numRobustPointsPerFrame; ++y) {
                    coordinates[x][y] = pointsListsIterator.next();
                }
                continue;
            }
            for (int y = 0; y < this.numRobustPointsPerFrame; ++y) {
                coordinates[x][y] = -1;
            }
        }
        LinkedList<Byte> byteList = new LinkedList<Byte>();
        for (int i = 0; i < numFrames; ++i) {
            for (int j = 0; j < this.numRobustPointsPerFrame; ++j) {
                if (coordinates[i][j] == -1) continue;
                int x = i;
                byteList.add((byte)(x >> 8));
                byteList.add((byte)x);
                int y = coordinates[i][j];
                byteList.add((byte)(y >> 8));
                byteList.add((byte)y);
                int intensity = (int)(spectorgramData[x][y] * 2.147483647E9);
                byteList.add((byte)(intensity >> 24));
                byteList.add((byte)(intensity >> 16));
                byteList.add((byte)(intensity >> 8));
                byteList.add((byte)intensity);
            }
        }
        fingerprint = new byte[byteList.size()];
        Iterator byteListIterator = byteList.iterator();
        int pointer = 0;
        while (byteListIterator.hasNext()) {
            fingerprint[pointer++] = (Byte)byteListIterator.next();
        }
        return fingerprint;
    }

    public byte[] getFingerprintFromFile(String fingerprintFile) {
        byte[] fingerprint = null;
        try {
            FileInputStream fis = new FileInputStream(fingerprintFile);
            fingerprint = this.getFingerprintFromInputStream(fis);
            ((InputStream)fis).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fingerprint;
    }

    public byte[] getFingerprintFromInputStream(InputStream inputStream) {
        byte[] fingerprint = null;
        try {
            fingerprint = new byte[inputStream.available()];
            inputStream.read(fingerprint);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fingerprint;
    }

    public void saveFingerprintAsFile(byte[] fingerprint, String filename) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(filename);
            fileOutputStream.write(fingerprint);
            fileOutputStream.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<Integer>[] getRobustPointList(double[][] spectrogramData) {
        int numX = spectrogramData.length;
        int numY = spectrogramData[0].length;
        double[][] allBanksIntensities = new double[numX][numY];
        int bandwidthPerBank = numY / this.numFilterBanks;
        for (int b = 0; b < this.numFilterBanks; ++b) {
            double[][] bankIntensities = new double[numX][bandwidthPerBank];
            for (int i = 0; i < numX; ++i) {
                for (int j = 0; j < bandwidthPerBank; ++j) {
                    bankIntensities[i][j] = spectrogramData[i][j + b * bandwidthPerBank];
                }
            }
            TopManyPointsProcessorChain processorChain = new TopManyPointsProcessorChain(bankIntensities, 1);
            double[][] processedIntensities = processorChain.getIntensities();
            for (int i = 0; i < numX; ++i) {
                for (int j = 0; j < bandwidthPerBank; ++j) {
                    allBanksIntensities[i][j + b * bandwidthPerBank] = processedIntensities[i][j];
                }
            }
        }
        LinkedList<int[]> robustPointList = new LinkedList<int[]>();
        for (int i = 0; i < allBanksIntensities.length; ++i) {
            for (int j = 0; j < allBanksIntensities[i].length; ++j) {
                if (!(allBanksIntensities[i][j] > 0.0)) continue;
                int[] point = new int[]{i, j};
                robustPointList.add(point);
            }
        }
        LinkedList[] robustLists = new LinkedList[spectrogramData.length];
        for (int i = 0; i < robustLists.length; ++i) {
            robustLists[i] = new LinkedList();
        }
        for (int[] coor : robustPointList) {
            robustLists[coor[0]].add(coor[1]);
        }
        return robustLists;
    }

    public static int getNumFrames(byte[] fingerprint) {
        if (fingerprint.length < 8) {
            return 0;
        }
        int numFrames = ((fingerprint[fingerprint.length - 8] & 0xFF) << 8 | fingerprint[fingerprint.length - 7] & 0xFF) + 1;
        return numFrames;
    }
}

