/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.api;

import com.musicg.math.rank.ArrayRankDouble;
import com.musicg.math.statistics.StandardDeviation;
import com.musicg.math.statistics.ZeroCrossingRate;
import com.musicg.wave.Wave;
import com.musicg.wave.WaveHeader;
import com.musicg.wave.extension.Spectrogram;

public class DetectionApi {
    protected WaveHeader waveHeader;
    protected int fftSampleSize;
    protected int numFrequencyUnit;
    protected double unitFrequency;
    protected double minFrequency;
    protected double maxFrequency;
    protected double minIntensity;
    protected double maxIntensity;
    protected double minStandardDeviation;
    protected double maxStandardDeviation;
    protected int highPass;
    protected int lowPass;
    protected int minNumZeroCross;
    protected int maxNumZeroCross;
    protected int lowerBoundary;
    protected int upperBoundary;
    protected int numRobust;

    public DetectionApi(WaveHeader waveHeader) {
        if (waveHeader.getChannels() == 1) {
            this.waveHeader = waveHeader;
            this.init();
        } else {
            System.err.println("DetectionAPI supports mono Wav only");
        }
    }

    protected void init() {
    }

    public boolean isSpecificSound(byte[] audioBytes) {
        int bytesPerSample = this.waveHeader.getBitsPerSample() / 8;
        int numSamples = audioBytes.length / bytesPerSample;
        if (numSamples > 0 && Integer.bitCount(numSamples) == 1) {
            this.fftSampleSize = numSamples;
            this.numFrequencyUnit = this.fftSampleSize / 2;
            this.unitFrequency = (double)this.waveHeader.getSampleRate() / 2.0 / (double)this.numFrequencyUnit;
            this.lowerBoundary = (int)((double)this.highPass / this.unitFrequency);
            this.upperBoundary = (int)((double)this.lowPass / this.unitFrequency);
            Wave wave = new Wave(this.waveHeader, audioBytes);
            short[] amplitudes = wave.getSampleAmplitudes();
            Spectrogram spectrogram = wave.getSpectrogram(this.fftSampleSize, 0);
            double[][] spectrogramData = spectrogram.getAbsoluteSpectrogramData();
            double[] spectrum = spectrogramData[0];
            int frequencyUnitRange = this.upperBoundary - this.lowerBoundary + 1;
            double[] rangedSpectrum = new double[frequencyUnitRange];
            System.arraycopy(spectrum, this.lowerBoundary, rangedSpectrum, 0, rangedSpectrum.length);
            if (frequencyUnitRange <= spectrum.length) {
                if (this.isPassedIntensity(spectrum) && this.isPassedStandardDeviation(spectrogramData) && this.isPassedZeroCrossingRate(amplitudes) && this.isPassedFrequency(rangedSpectrum)) {
                    return true;
                }
            } else {
                System.err.println("is error: the wave needed to be higher sample rate");
            }
        } else {
            System.out.println("The sample size must be a power of 2");
        }
        return false;
    }

    protected void normalizeSpectrogramData(double[][] spectrogramData) {
        double maxAmp = Double.MIN_VALUE;
        double minAmp = Double.MAX_VALUE;
        for (int i = 0; i < spectrogramData.length; ++i) {
            for (int j = 0; j < spectrogramData[i].length; ++j) {
                if (spectrogramData[i][j] > maxAmp) {
                    maxAmp = spectrogramData[i][j];
                    continue;
                }
                if (!(spectrogramData[i][j] < minAmp)) continue;
                minAmp = spectrogramData[i][j];
            }
        }
        double minValidAmp = 1.0E-11f;
        if (minAmp == 0.0) {
            minAmp = minValidAmp;
        }
        double diff = Math.log10(maxAmp / minAmp);
        for (int i = 0; i < spectrogramData.length; ++i) {
            for (int j = 0; j < spectrogramData[i].length; ++j) {
                spectrogramData[i][j] = spectrogramData[i][j] < minValidAmp ? 0.0 : Math.log10(spectrogramData[i][j] / minAmp) / diff;
            }
        }
    }

    protected boolean isPassedStandardDeviation(double[][] spectrogramData) {
        this.normalizeSpectrogramData(spectrogramData);
        double[] spectrum = spectrogramData[spectrogramData.length - 1];
        double[] robustFrequencies = new double[this.numRobust];
        ArrayRankDouble arrayRankDouble = new ArrayRankDouble();
        double nthValue = arrayRankDouble.getNthOrderedValue(spectrum, this.numRobust, false);
        int count = 0;
        for (int i = 0; i < spectrum.length; ++i) {
            if (!(spectrum[i] >= nthValue)) continue;
            robustFrequencies[count++] = spectrum[i];
            if (count >= this.numRobust) break;
        }
        StandardDeviation standardDeviation = new StandardDeviation();
        standardDeviation.setValues(robustFrequencies);
        double sd = standardDeviation.evaluate();
        boolean result = sd >= this.minStandardDeviation && sd <= this.maxStandardDeviation;
        return result;
    }

    protected boolean isPassedFrequency(double[] spectrum) {
        ArrayRankDouble arrayRankDouble = new ArrayRankDouble();
        double robustFrequency = (double)arrayRankDouble.getMaxValueIndex(spectrum) * this.unitFrequency;
        boolean result = robustFrequency >= this.minFrequency && robustFrequency <= this.maxFrequency;
        return result;
    }

    protected boolean isPassedIntensity(double[] spectrum) {
        double intensity = 0.0;
        for (int i = 0; i < spectrum.length; ++i) {
            intensity += spectrum[i];
        }
        boolean result = (intensity /= (double)spectrum.length) > this.minIntensity && intensity <= this.maxIntensity;
        return result;
    }

    protected boolean isPassedZeroCrossingRate(short[] amplitudes) {
        ZeroCrossingRate zcr = new ZeroCrossingRate(amplitudes, 1.0);
        int numZeroCrosses = (int)zcr.evaluate();
        boolean result = numZeroCrosses >= this.minNumZeroCross && numZeroCrosses <= this.maxNumZeroCross;
        return result;
    }
}

