/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize.plugins;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import weka.gui.ExtensionFileFilter;
import weka.gui.visualize.plugins.JGraphTTreeVisualization;
import weka.gui.visualize.plugins.TreeVisualizePlugin;

public class JGraphTTreeVisualizationPlugin
implements TreeVisualizePlugin {
    protected JFileChooser m_FileChooserDotty;

    protected JFileChooser getFileChooserDotty() {
        if (this.m_FileChooserDotty == null) {
            ExtensionFileFilter filter = new ExtensionFileFilter(new String[]{".dotty", ".dot"}, "GraphViz dot file");
            this.m_FileChooserDotty = new JFileChooser();
            this.m_FileChooserDotty.addChoosableFileFilter((FileFilter)filter);
            this.m_FileChooserDotty.setFileFilter((FileFilter)filter);
            this.m_FileChooserDotty.setFileSelectionMode(0);
            this.m_FileChooserDotty.setAcceptAllFileFilterUsed(false);
        }
        return this.m_FileChooserDotty;
    }

    protected JFileChooser getFileChooserGraphML() {
        if (this.m_FileChooserDotty == null) {
            ExtensionFileFilter filter = new ExtensionFileFilter(new String[]{".graphml"}, "GraphML file");
            this.m_FileChooserDotty = new JFileChooser();
            this.m_FileChooserDotty.addChoosableFileFilter((FileFilter)filter);
            this.m_FileChooserDotty.setFileFilter((FileFilter)filter);
            this.m_FileChooserDotty.setFileSelectionMode(0);
            this.m_FileChooserDotty.setAcceptAllFileFilterUsed(false);
        }
        return this.m_FileChooserDotty;
    }

    public JMenuItem getVisualizeMenuItem(final String dotty, String name) {
        JMenu result = new JMenu("Visualize tree (JGraphT)");
        JMenuItem menuitem = new JMenuItem("Show graph...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = JGraphTTreeVisualization.getSingleton().displayGraph(dotty);
                if (msg != null) {
                    JOptionPane.showMessageDialog(null, msg, "Error displaying graph", 0);
                }
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Save as dotty...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = JGraphTTreeVisualizationPlugin.this.getFileChooserDotty();
                int retVal = fileChooser.showSaveDialog(null);
                if (retVal != 0) {
                    return;
                }
                String msg = JGraphTTreeVisualization.getSingleton().saveDotty(dotty, "" + fileChooser.getSelectedFile());
                if (msg != null) {
                    JOptionPane.showMessageDialog(null, msg, "Error saving as dotty", 0);
                }
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Save as GraphML...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = JGraphTTreeVisualizationPlugin.this.getFileChooserGraphML();
                int retVal = fileChooser.showSaveDialog(null);
                if (retVal != 0) {
                    return;
                }
                String msg = JGraphTTreeVisualization.getSingleton().saveGraphml(dotty, "" + fileChooser.getSelectedFile());
                if (msg != null) {
                    JOptionPane.showMessageDialog(null, msg, "Error saving as GraphML", 0);
                }
            }
        });
        result.add(menuitem);
        return result;
    }

    public String getMinVersion() {
        return "3.7.9";
    }

    public String getMaxVersion() {
        return "4.0.0";
    }

    public String getDesignVersion() {
        return "3.7.11";
    }
}

