/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize.plugins;

import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JFrame;
import org.jgrapht.Graph;
import org.jgrapht.ext.JGraphXAdapter;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.io.ComponentAttributeProvider;
import org.jgrapht.io.ComponentNameProvider;
import org.jgrapht.io.ComponentUpdater;
import org.jgrapht.io.DOTImporter;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.GraphMLExporter;
import org.jgrapht.io.VertexProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleComponentUpdater;
import weka.gui.visualize.plugins.jgrapht.SimpleEdge;
import weka.gui.visualize.plugins.jgrapht.SimpleEdgeAttributeProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleEdgeIDProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleEdgeLabelProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleEdgeProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleVertex;
import weka.gui.visualize.plugins.jgrapht.SimpleVertexAttributeProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleVertexIDProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleVertexLabelProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleVertexProvider;

public class JGraphTTreeVisualization {
    protected boolean DEBUG = false;
    protected static JGraphTTreeVisualization m_Singleton;

    protected JGraphTTreeVisualization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String save(String type, String content, String filename) {
        String result = null;
        if (this.DEBUG) {
            System.out.println("Saving " + type + " to: " + filename);
        }
        FileWriter fwriter = null;
        BufferedWriter bwriter = null;
        try {
            fwriter = new FileWriter(filename);
            bwriter = new BufferedWriter(fwriter);
            bwriter.write(content);
            bwriter.newLine();
        }
        catch (Exception e) {
            result = "Failed to write " + type + " string to " + filename;
            System.err.println(result);
            e.printStackTrace();
            result = result + "\n" + e;
        }
        finally {
            if (bwriter != null) {
                try {
                    bwriter.flush();
                    bwriter.close();
                }
                catch (Exception exception) {}
            }
            if (fwriter != null) {
                try {
                    fwriter.flush();
                    fwriter.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public String saveDotty(String dotty, String filename) {
        return this.save("dotty", dotty, filename);
    }

    public String saveGraphml(String dotty, String filename) {
        try {
            StringWriter writer = new StringWriter();
            DirectedPseudograph<SimpleVertex, SimpleEdge> graph = this.importDotty(dotty);
            GraphMLExporter exporter = new GraphMLExporter((ComponentNameProvider)new SimpleVertexIDProvider(), (ComponentNameProvider)new SimpleVertexLabelProvider(), (ComponentAttributeProvider)new SimpleVertexAttributeProvider(), (ComponentNameProvider)new SimpleEdgeIDProvider(), (ComponentNameProvider)new SimpleEdgeLabelProvider(), (ComponentAttributeProvider)new SimpleEdgeAttributeProvider());
            exporter.exportGraph(graph, (Writer)writer);
            return this.save("graphml", writer.toString(), filename);
        }
        catch (Exception e) {
            return "Failed to export dotty to GraphML: " + e;
        }
    }

    public DirectedPseudograph<SimpleVertex, SimpleEdge> importDotty(String dotty) throws Exception {
        DirectedPseudograph result = new DirectedPseudograph(SimpleEdge.class);
        SimpleVertexProvider vp = new SimpleVertexProvider();
        SimpleEdgeProvider ep = new SimpleEdgeProvider();
        SimpleComponentUpdater cu = new SimpleComponentUpdater();
        DOTImporter importer = new DOTImporter((VertexProvider)vp, (EdgeProvider)ep, (ComponentUpdater)cu);
        importer.importGraph((Graph)result, (Reader)new StringReader(dotty));
        return result;
    }

    public String displayGraph(String dotty) {
        try {
            DirectedPseudograph<SimpleVertex, SimpleEdge> graph = this.importDotty(dotty);
            JGraphXAdapter jgxAdapter = new JGraphXAdapter(graph);
            jgxAdapter.setCellsEditable(false);
            jgxAdapter.setLabelsVisible(true);
            mxGraphComponent component = new mxGraphComponent((mxGraph)jgxAdapter);
            component.getConnectionHandler().setEnabled(false);
            component.setPanning(true);
            component.setConnectable(false);
            component.setDragEnabled(true);
            component.setZoomFactor(5.0);
            component.setZoomPolicy(1);
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(2);
            frame.getContentPane().add((Component)component);
            frame.setSize(new Dimension(800, 800));
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            mxCompactTreeLayout layout = new mxCompactTreeLayout((mxGraph)jgxAdapter);
            layout.setHorizontal(false);
            layout.execute(jgxAdapter.getDefaultParent());
            return null;
        }
        catch (Exception e) {
            return "Failed to display graph: " + e;
        }
    }

    public static synchronized JGraphTTreeVisualization getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new JGraphTTreeVisualization();
        }
        return m_Singleton;
    }
}

