/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMBitMap;
import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.RMHash;
import com.github.fppt.jedismock.datastructures.RMHyperLogLog;
import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.RMSet;
import com.github.fppt.jedismock.datastructures.RMString;
import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.RMStream;
import com.github.fppt.jedismock.server.RedisClient;
import com.github.fppt.jedismock.storage.ExpiringKeyValueStorage;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RedisBase {
    private final Map<Slice, Set<RedisClient>> subscribers = new HashMap<Slice, Set<RedisClient>>();
    private final Map<Slice, Set<RedisClient>> psubscribers = new HashMap<Slice, Set<RedisClient>>();
    private final Map<Slice, Set<OperationExecutorState>> watchedKeys = new HashMap<Slice, Set<OperationExecutorState>>();
    private final ExpiringKeyValueStorage keyValueStorage = new ExpiringKeyValueStorage(key -> this.watchedKeys.getOrDefault(key, Collections.emptySet()).forEach(OperationExecutorState::watchedKeyIsAffected));
    private final Map<String, String> cachedLuaScripts = new HashMap<String, String>();

    public Set<Slice> keys() {
        Iterator<Slice> slices = this.keyValueStorage.values().keySet().iterator();
        HashSet<Slice> result = new HashSet<Slice>();
        while (slices.hasNext()) {
            Slice key = slices.next();
            if (this.keyValueStorage.isKeyOutdated(key)) {
                slices.remove();
                continue;
            }
            result.add(key);
        }
        return result;
    }

    public RMDataStructure getValue(Slice key) {
        return this.keyValueStorage.getValue(key);
    }

    private <T extends RMDataStructure> T getStructure(Slice key, Class<T> tClass) {
        RMDataStructure value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (tClass.isInstance(value)) {
            return (T)value;
        }
        value.raiseTypeCastException();
        return null;
    }

    public RMStream getStream(Slice key) {
        return this.getStructure(key, RMStream.class);
    }

    public RMSet getSet(Slice key) {
        return this.getStructure(key, RMSet.class);
    }

    public RMZSet getZSet(Slice key) {
        return this.getStructure(key, RMZSet.class);
    }

    public RMList getList(Slice key) {
        return this.getStructure(key, RMList.class);
    }

    public RMHash getHash(Slice key) {
        return this.getStructure(key, RMHash.class);
    }

    public RMHyperLogLog getHLL(Slice key) {
        return this.getStructure(key, RMHyperLogLog.class);
    }

    public RMString getRMString(Slice key) {
        return this.getStructure(key, RMString.class);
    }

    public RMBitMap getBitMap(Slice key) {
        RMDataStructure value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof RMBitMap) {
            return (RMBitMap)value;
        }
        if (value instanceof RMString) {
            return new RMBitMap(((RMString)value).getStoredData());
        }
        value.raiseTypeCastException();
        return null;
    }

    public Slice getSlice(Slice key) {
        RMDataStructure value = this.getValue(key);
        if (value == null) {
            return null;
        }
        return value.getAsSlice();
    }

    public Slice getSlice(Slice key1, Slice key2) {
        RMHash value = this.getHash(key1);
        if (value == null) {
            return null;
        }
        Map<Slice, Slice> innerMap = value.getStoredData();
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(key2);
    }

    public Map<Slice, Slice> getFieldsAndValues(Slice hash) {
        RMHash hashTable = this.getHash(hash);
        if (hashTable == null) {
            return Collections.emptyMap();
        }
        return hashTable.getStoredData();
    }

    public Long getTTL(Slice key) {
        return this.keyValueStorage.getTTL(key);
    }

    public long setTTL(Slice key, long ttl) {
        return this.keyValueStorage.setTTL(key, ttl);
    }

    public long setDeadline(Slice key, long deadline) {
        return this.keyValueStorage.setDeadline(key, deadline);
    }

    public void clear() {
        this.keyValueStorage.clear();
        this.subscribers.clear();
    }

    public void putSlice(Slice key, Slice value, Long ttl) {
        this.keyValueStorage.put(key, value, ttl);
    }

    public void putSlice(Slice key1, Slice key2, Slice value, Long ttl) {
        this.keyValueStorage.put(key1, key2, value, ttl);
    }

    public void putValueWithoutClearingTtl(Slice key, RMDataStructure value) {
        this.putValue(key, value, null);
    }

    public void putValue(Slice key, RMDataStructure value, Long ttl) {
        this.keyValueStorage.put(key, value, ttl);
    }

    public void putValue(Slice key, RMDataStructure value) {
        this.keyValueStorage.put(key, value, (Long)-1L);
    }

    public void deleteValue(Slice key) {
        this.keyValueStorage.delete(key);
    }

    public void deleteValue(Slice key1, Slice key2) {
        this.keyValueStorage.delete(key1, key2);
    }

    public void addSubscriber(Slice channel, RedisClient client) {
        HashSet<RedisClient> newClient = new HashSet<RedisClient>();
        newClient.add(client);
        this.subscribers.merge(channel, newClient, (currentSubscribers, newSubscribers) -> {
            currentSubscribers.addAll(newSubscribers);
            return currentSubscribers;
        });
    }

    public void subscribeByPattern(Slice pattern, RedisClient client) {
        HashSet<RedisClient> newClient = new HashSet<RedisClient>();
        newClient.add(client);
        this.psubscribers.merge(pattern, newClient, (currentSubscribers, newSubscribers) -> {
            currentSubscribers.addAll(newSubscribers);
            return currentSubscribers;
        });
    }

    public boolean removeSubscriber(Slice channel, RedisClient client) {
        return this.removeSubscriber(channel, client, this.subscribers);
    }

    public boolean removePSubscriber(Slice channel, RedisClient client) {
        return this.removeSubscriber(channel, client, this.psubscribers);
    }

    private boolean removeSubscriber(Slice channel, RedisClient client, Map<Slice, Set<RedisClient>> subscribers) {
        if (subscribers.containsKey(channel)) {
            Set<RedisClient> redisClients = subscribers.get(channel);
            redisClients.remove(client);
            if (redisClients.isEmpty()) {
                subscribers.remove(channel);
            }
            return true;
        }
        return false;
    }

    public Set<RedisClient> getSubscribers(Slice channel) {
        HashSet<RedisClient> subs = new HashSet<RedisClient>(Collections.emptySet());
        if (this.subscribers.containsKey(channel)) {
            subs.addAll((Collection<RedisClient>)this.subscribers.get(channel));
        }
        return subs;
    }

    public Map<Slice, Set<RedisClient>> getPsubscribers(Slice channel) {
        HashMap<Slice, Set<RedisClient>> matchingPatterns = new HashMap<Slice, Set<RedisClient>>();
        String channelStr = channel.toString();
        for (Map.Entry<Slice, Set<RedisClient>> patternSubscribedClients : this.psubscribers.entrySet()) {
            Slice jedisPattern = patternSubscribedClients.getKey();
            String regexpPattern = RedisBase.getRegexpFromPattern(jedisPattern);
            if (!channelStr.matches(regexpPattern)) continue;
            matchingPatterns.put(jedisPattern, patternSubscribedClients.getValue());
        }
        return matchingPatterns;
    }

    private static String getRegexpFromPattern(Slice pattern) {
        String patternStr = pattern.toString();
        if (patternStr.isEmpty()) {
            return ".*";
        }
        return Utils.createRegexFromGlob(patternStr);
    }

    public int getNumpat() {
        return this.psubscribers.size();
    }

    public Set<Slice> getChannels() {
        return this.subscribers.keySet();
    }

    public List<Slice> getSubscriptions(RedisClient client) {
        ArrayList<Slice> subscriptions = new ArrayList<Slice>();
        this.subscribers.forEach((channel, subscribers) -> {
            if (subscribers.contains(client)) {
                subscriptions.add((Slice)channel);
            }
        });
        return subscriptions;
    }

    public List<Slice> getPSubscriptions(RedisClient client) {
        ArrayList<Slice> subscriptions = new ArrayList<Slice>();
        this.psubscribers.forEach((channel, subscribers) -> {
            if (subscribers.contains(client)) {
                subscriptions.add((Slice)channel);
            }
        });
        return subscriptions;
    }

    public boolean exists(Slice slice) {
        return this.keyValueStorage.exists(slice);
    }

    public Slice type(Slice slice) {
        return this.keyValueStorage.type(slice);
    }

    public void watch(OperationExecutorState state, Slice key) {
        this.watchedKeys.computeIfAbsent(key, k -> new HashSet()).add(state);
    }

    public void unwatchSingleKey(OperationExecutorState state, Slice key) {
        Set<OperationExecutorState> states = this.watchedKeys.get(key);
        if (states != null) {
            states.remove(state);
            if (states.isEmpty()) {
                this.watchedKeys.remove(key);
            }
        }
    }

    public void markKeyModified(Slice key) {
        ((Set)this.watchedKeys.getOrDefault(key, new HashSet())).forEach(OperationExecutorState::watchedKeyIsAffected);
    }

    public String getCachedLuaScript(String sha1) {
        return this.cachedLuaScripts.get(sha1.toLowerCase());
    }

    public boolean cachedLuaScriptExists(String sha1) {
        return this.cachedLuaScripts.containsKey(sha1.toLowerCase());
    }

    public void flushCachedLuaScrips() {
        this.cachedLuaScripts.clear();
    }

    public String addCachedLuaScript(String sha1, String script) {
        return this.cachedLuaScripts.put(sha1, script);
    }
}

