/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.server;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.EOFException;
import com.github.fppt.jedismock.exception.ParseErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SliceParser {
    public static byte consumeByte(InputStream messageInput) throws EOFException {
        int b;
        try {
            b = messageInput.read();
        }
        catch (IOException e) {
            throw new EOFException();
        }
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public static void expectByte(InputStream messageInput, byte c) throws ParseErrorException, EOFException {
        if (SliceParser.consumeByte(messageInput) != c) {
            throw new ParseErrorException();
        }
    }

    public static long consumeLong(InputStream messageInput) throws ParseErrorException {
        byte c;
        long ret = 0L;
        boolean hasLong = false;
        while ((c = SliceParser.consumeByte(messageInput)) != 13) {
            if (!SliceParser.isNumber(c)) {
                throw new ParseErrorException();
            }
            ret = ret * 10L + (long)c - 48L;
            hasLong = true;
        }
        if (!hasLong) {
            throw new ParseErrorException();
        }
        return ret;
    }

    public static Slice consumeSlice(InputStream messageInput, long len) throws ParseErrorException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        for (long i = 0L; i < len; ++i) {
            bo.write(SliceParser.consumeByte(messageInput));
        }
        return Slice.create(bo.toByteArray());
    }

    public static long consumeCount(InputStream messageInput) throws ParseErrorException {
        SliceParser.expectByte(messageInput, (byte)42);
        long count = SliceParser.consumeLong(messageInput);
        SliceParser.expectByte(messageInput, (byte)10);
        return count;
    }

    public static long consumeCount(byte[] message) throws ParseErrorException {
        ByteArrayInputStream stream = new ByteArrayInputStream(message);
        return SliceParser.consumeCount(stream);
    }

    public static int consumeInteger(byte[] message) throws ParseErrorException {
        ByteArrayInputStream stream = new ByteArrayInputStream(message);
        return SliceParser.consumeInteger(stream);
    }

    public static int consumeInteger(InputStream messageInput) throws ParseErrorException {
        SliceParser.expectByte(messageInput, (byte)58);
        long count = SliceParser.consumeLong(messageInput);
        return (int)count;
    }

    private static boolean isNumber(byte c) {
        return 48 <= c && c <= 57;
    }

    public static Slice consumeParameter(InputStream messageInput) throws ParseErrorException {
        SliceParser.expectByte(messageInput, (byte)36);
        long len = SliceParser.consumeLong(messageInput);
        SliceParser.expectByte(messageInput, (byte)10);
        Slice para = SliceParser.consumeSlice(messageInput, len);
        SliceParser.expectByte(messageInput, (byte)13);
        SliceParser.expectByte(messageInput, (byte)10);
        return para;
    }

    public static Slice consumeParameter(byte[] message) throws ParseErrorException {
        ByteArrayInputStream stream = new ByteArrayInputStream(message);
        return SliceParser.consumeParameter(stream);
    }
}

