/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.hashes;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.keys.Scan;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@RedisCommand(value="hscan")
public class HScan
extends Scan {
    private Slice keySlice;

    HScan(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected void doOptionalWork() {
        this.keySlice = this.params().get(0);
        this.cursorSlice = this.params().get(1);
    }

    @Override
    protected List<Slice> getMatchingValues(String regex, long cursor, long count) {
        Map<Slice, Slice> fieldAndValueMap = this.base().getFieldsAndValuesReadOnly(this.keySlice);
        this.size = fieldAndValueMap.size();
        return fieldAndValueMap.entrySet().stream().skip(cursor).limit(count).filter(e -> ((Slice)e.getKey()).toString().matches(regex)).flatMap(e -> Stream.of((Slice)e.getKey(), (Slice)e.getValue())).map(Response::bulkString).collect(Collectors.toList());
    }
}

