/*
 * Decompiled with CFR 0.152.
 */
package org.fordes.jfx.core;

import com.jthemedetecor.OsThemeDetector;
import java.awt.AWTException;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.fordes.jfx.annotation.JFXApplication;
import org.fordes.jfx.annotation.Tray;
import org.fordes.jfx.core.StageReadyEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.EventListener;

@JFXApplication
public abstract class ProxyApplication {
    public static final FXMLLoader loader = new FXMLLoader();
    @Resource
    public ConfigurableApplicationContext context;

    @EventListener
    public void handleEvent(StageReadyEvent event) throws IOException, AWTException {
        Tray tray;
        StackPane root;
        Stage stage = event.getStage();
        JFXApplication property = this.getClass().getAnnotation(JFXApplication.class);
        this.loadFXMLBefore(stage, property);
        if (ProxyApplication.isNotEmpty(property.value())) {
            loader.setControllerFactory(arg_0 -> ((ConfigurableApplicationContext)this.context).getBean(arg_0));
            loader.setLocation(this.context.getResource(property.value()).getURL());
            root = (Parent)loader.load();
        } else {
            root = new StackPane();
        }
        if (ProxyApplication.isNotEmpty(property.fonts())) {
            for (String path : property.fonts()) {
                Font.loadFont((InputStream)this.context.getResource(path).getInputStream(), (double)0.0);
            }
        }
        if (ProxyApplication.isNotEmpty(property.icons())) {
            for (String icon : property.icons()) {
                stage.getIcons().add((Object)new Image(this.context.getResource(icon).getInputStream()));
            }
        }
        Scene scene = new Scene((Parent)root);
        if (ProxyApplication.isNotEmpty(property.css())) {
            scene.getStylesheets().addAll((Object[])property.css());
        }
        if (ProxyApplication.isNotEmpty(property.style())) {
            stage.initStyle(property.style());
        }
        if (ProxyApplication.isNotEmpty(property.title())) {
            stage.setTitle(property.title());
        }
        if (ProxyApplication.isNotEmpty(property.fullScreenExitHint())) {
            stage.setFullScreenExitHint(property.fullScreenExitHint());
        }
        stage.setScene(scene);
        if (property.osThemeDetector()) {
            OsThemeDetector detector = OsThemeDetector.getDetector();
            this.registerOsThemeDetector(detector, stage, property);
        }
        if ((tray = property.systemTray()) != null && tray.value()) {
            System.setProperty("java.awt.headless", String.valueOf(tray.headless()));
            if (SystemTray.isSupported() && tray.image() != null && !tray.image().equals("")) {
                TrayIcon trayIcon = new TrayIcon(ImageIO.read(this.context.getResource(tray.image()).getInputStream()));
                trayIcon.setToolTip(tray.toolTip());
                trayIcon.setImageAutoSize(tray.imageAutoSize());
                trayIcon.setActionCommand(tray.actionCommand());
                this.initSystemTray(trayIcon, stage, tray);
                SystemTray.getSystemTray().add(trayIcon);
            } else {
                throw new RuntimeException("SystemTray is not support!");
            }
        }
        this.initAfter(stage);
        event.getStage().show();
    }

    public void loadFXMLBefore(Stage stage, JFXApplication property) {
    }

    public void initAfter(Stage stage) {
    }

    public void registerOsThemeDetector(OsThemeDetector detector, Stage stage, JFXApplication property) {
        if (ProxyApplication.isNotEmpty(property.darkStyleClass())) {
            detector.registerListener(isDark -> {
                if (isDark.booleanValue()) {
                    if (!stage.getScene().getRoot().getStyleClass().contains((Object)property.darkStyleClass())) {
                        stage.getScene().getRoot().getStyleClass().add((Object)property.darkStyleClass());
                    }
                } else {
                    stage.getScene().getRoot().getStyleClass().remove((Object)property.darkStyleClass());
                }
            });
        }
    }

    public void initSystemTray(TrayIcon trayIcon, Stage stage, Tray property) {
    }

    static <T> boolean isNotEmpty(T value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            return !((String)value).isEmpty();
        }
        if (value instanceof Object[]) {
            return ((Object[])value).length != 0;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        return true;
    }
}

