/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.netlib.generator;

import com.google.common.io.CharStreams;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class F2jJavadocExtractor {
    private final File jar;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRawJavadoc(Method method) throws IOException {
        String filename = method.getDeclaringClass().getCanonicalName().replace(".", "/") + ".html";
        ZipFile zip = new ZipFile(this.jar);
        try {
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                if (!entry.getName().endsWith(filename)) continue;
                InputStreamReader stream = new InputStreamReader(zip.getInputStream(entry), "UTF-8");
                try {
                    String string = CharStreams.toString((Readable)stream);
                    return string;
                }
                finally {
                    if (Collections.singletonList(stream).get(0) != null) {
                        stream.close();
                    }
                }
            }
            String string = "";
            return string;
        }
        finally {
            if (Collections.singletonList(zip).get(0) != null) {
                zip.close();
            }
        }
    }

    public String getJavadocDescription(Method method) throws IOException {
        String javadoc;
        Pattern pattern = Pattern.compile("seymour@cs.utk.edu</a> with any questions.\n<p>");
        Matcher matcher = pattern.matcher(javadoc = this.getRawJavadoc(method));
        boolean matched = matcher.find();
        if (!matched) {
            return String.format("<i>{@code %s} could not find docs for {@code %s} in {@code %s}</i>.", this.getClass().getSimpleName(), method, this.jar.getName());
        }
        int start = matcher.end();
        int end = javadoc.indexOf("</pre>", start);
        javadoc = javadoc.substring(start, end).replaceAll("\n\\s*c", "\n").replace("\n\n", "\n");
        return "<pre><code>" + javadoc + " * </code></pre>";
    }

    @ConstructorProperties(value={"jar"})
    public F2jJavadocExtractor(File jar) {
        this.jar = jar;
    }
}

