/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.idlabFunctions.state;

import be.ugent.knows.idlabFunctions.state.MapDBContainer;
import be.ugent.knows.idlabFunctions.state.MapState;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBState
implements MapState {
    private static final Logger log = LoggerFactory.getLogger(MapDBState.class);
    private static final Map<String, MapDBContainer> stateFileToMap = new ConcurrentHashMap<String, MapDBContainer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(String stateFilePath, String key, String value) {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            MapDBContainer container = stateFileToMap.computeIfAbsent(stateFilePath, mapKey -> new MapDBContainer(stateFilePath));
            return container.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Integer> putAndReturnIndex(String stateFilePath, String key, String value) {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            MapDBContainer container = stateFileToMap.computeIfAbsent(stateFilePath, mapKey -> new MapDBContainer(stateFilePath));
            return container.putAndReturnIndex(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(String stateFilePath, String key, List<String> value) {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            MapDBContainer container = stateFileToMap.computeIfAbsent(stateFilePath, mapKey -> new MapDBContainer(stateFilePath));
            container.replace(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(String stateFilePath, String key) {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            MapDBContainer container = stateFileToMap.computeIfAbsent(stateFilePath, mapKey -> new MapDBContainer(stateFilePath));
            return container.hasKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getEntries(String stateFilePath) {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            MapDBContainer container = stateFileToMap.computeIfAbsent(stateFilePath, mapKey -> new MapDBContainer(stateFilePath));
            return container.getEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllState() {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            stateFileToMap.forEach((stateFilePath, mapContainer) -> {
                mapContainer.close();
                File stateFile = new File((String)stateFilePath);
                if (!stateFile.delete()) {
                    log.warn("Could not delete map state file {}", stateFilePath);
                }
            });
            stateFileToMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAllState() {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            stateFileToMap.forEach((stateFilePath, mapContainer) -> mapContainer.commit());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(String stateFilePath, String key) {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            if (stateFileToMap.containsKey(stateFilePath)) {
                return stateFileToMap.get(stateFilePath).count(key);
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String stateFilePath, String key) {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            MapDBContainer container = stateFileToMap.computeIfAbsent(stateFilePath, mapKey -> new MapDBContainer(stateFilePath));
            container.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<String, MapDBContainer> map = stateFileToMap;
        synchronized (map) {
            stateFileToMap.forEach((stateFilePath, mapContainer) -> mapContainer.close());
            stateFileToMap.clear();
        }
    }
}

