/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.idlabFunctions.state;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.IndexTreeList;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBContainer {
    private static final Logger logger = LoggerFactory.getLogger(MapDBContainer.class);
    private final DB mapDB;
    private final ScheduledExecutorService committer;

    public MapDBContainer(String dbFilePath) {
        DBMaker.Maker dbMaker;
        if (dbFilePath != null) {
            File dbPArentFile = new File(dbFilePath).getParentFile();
            if (!dbPArentFile.exists() && !dbPArentFile.mkdirs()) {
                logger.warn(dbPArentFile + " does not exist and could not be created, creating a temporary file state.");
                dbMaker = DBMaker.tempFileDB();
            } else {
                dbMaker = DBMaker.fileDB((String)dbFilePath);
            }
        } else {
            logger.debug("dbFilePath is null, creating a temporary state.");
            dbMaker = DBMaker.tempFileDB();
        }
        this.mapDB = dbMaker.fileMmapEnableIfSupported().closeOnJvmShutdown().make();
        this.committer = Executors.newSingleThreadScheduledExecutor();
        this.committer.scheduleAtFixedRate(() -> ((DB)this.mapDB).commit(), 10L, 10L, TimeUnit.SECONDS);
        this.addShutDownHook();
    }

    public String put(String key, String value) {
        IndexTreeList values = (IndexTreeList)this.mapDB.indexTreeList(key, (Serializer)Serializer.STRING).createOrOpen();
        if (values.isEmpty()) {
            values.add((Object)value);
            return null;
        }
        if (values.contains((Object)value)) {
            return (String)values.get(values.size() - 1);
        }
        String returnValue = (String)values.get(values.size() - 1);
        values.add((Object)value);
        return returnValue;
    }

    public Optional<Integer> putAndReturnIndex(String key, String value) {
        IndexTreeList values = (IndexTreeList)this.mapDB.indexTreeList(key, (Serializer)Serializer.STRING).createOrOpen();
        if (values.isEmpty()) {
            values.add((Object)value);
            return Optional.of(0);
        }
        if (values.contains((Object)value)) {
            return Optional.empty();
        }
        values.add((Object)value);
        return Optional.of(values.size() - 1);
    }

    public boolean hasKey(String key) {
        IndexTreeList values = (IndexTreeList)this.mapDB.indexTreeList(key, (Serializer)Serializer.STRING).createOrOpen();
        return !values.isEmpty();
    }

    public Map<String, List<String>> getEntries() {
        HashMap<String, List<String>> entries = new HashMap<String, List<String>>();
        for (String key : this.mapDB.getAllNames()) {
            IndexTreeList values = (IndexTreeList)this.mapDB.indexTreeList(key, (Serializer)Serializer.STRING).createOrOpen();
            entries.put(key, (List<String>)values);
        }
        return entries;
    }

    public long count(String key) {
        Object valuesObject = this.mapDB.get(key);
        if (valuesObject == null) {
            return 0L;
        }
        List values = Collections.unmodifiableList((List)valuesObject);
        return values.size();
    }

    public void replace(String key, List<String> value) {
        IndexTreeList values = (IndexTreeList)this.mapDB.indexTreeList(key, (Serializer)Serializer.STRING).createOrOpen();
        values.clear();
        values.addAll(value);
    }

    public void close() {
        this.committer.shutdown();
        this.mapDB.close();
    }

    public void commit() {
        this.mapDB.commit();
    }

    private void addShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.debug("Running shutdown hook; closing mapdb");
            this.close();
        }));
    }

    public void remove(String key) {
        IndexTreeList values = (IndexTreeList)this.mapDB.indexTreeList(key, (Serializer)Serializer.STRING).createOrOpen();
        values.clear();
    }
}

