/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.idlabFunctions.state;

import be.ugent.knows.idlabFunctions.state.MapState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInMemoryMapState<K, V>
implements MapState<List<V>, K, V> {
    private static final Logger log = LoggerFactory.getLogger(SimpleInMemoryMapState.class);
    private final Map<String, Map<K, List<V>>> stateFileToMap = new HashMap<String, Map<K, List<V>>>();

    private synchronized Map<K, List<V>> computeMap(String stateFilePath) {
        return this.stateFileToMap.computeIfAbsent(stateFilePath, mapKey -> {
            File stateFile = new File(stateFilePath);
            Map newMap = new HashMap();
            if (stateFile.exists() && stateFile.isFile() && stateFile.canRead()) {
                try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(stateFilePath)));){
                    newMap = (Map)in.readObject();
                }
                catch (IOException | ClassNotFoundException e) {
                    log.warn("Cannot load state map from file {}. Creating empty map!", (Object)stateFilePath);
                }
            }
            return newMap;
        });
    }

    @Override
    public synchronized V put(String stateFilePath, K key, V value) {
        Map<Object, List<List>> map = this.computeMap(stateFilePath);
        List values = map.computeIfAbsent(key, k -> new ArrayList());
        if (values.isEmpty()) {
            values.add(value);
            map.put(key, values);
            return null;
        }
        if (values.contains(value)) {
            return (V)values.get(values.size() - 1);
        }
        Object returnValue = values.get(values.size() - 1);
        values.add(value);
        map.put(key, values);
        return (V)returnValue;
    }

    @Override
    public synchronized Optional<Integer> putAndReturnIndex(String stateFilePath, K key, V value) {
        Map<Object, List<List>> map = this.computeMap(stateFilePath);
        List values = map.computeIfAbsent(key, k -> new ArrayList(4));
        if (values.isEmpty()) {
            values.add(value);
            map.put(key, values);
            return Optional.of(0);
        }
        if (values.contains(value)) {
            return Optional.empty();
        }
        values.add(value);
        map.put(key, values);
        return Optional.of(values.size() - 1);
    }

    @Override
    public synchronized Optional<Integer> replaceAndReturnIndex(String stateFilePath, K key, V value) {
        Map<K, List<List<V>>> map = this.computeMap(stateFilePath);
        if (map.containsKey(key)) {
            List<V> values = map.get(key);
            if (values.contains(value)) {
                return Optional.empty();
            }
            map.put(key, Collections.singletonList(value));
            return Optional.of(0);
        }
        map.put(key, Collections.singletonList(value));
        return Optional.of(0);
    }

    @Override
    public synchronized void replace(String stateFilePath, K key, List<V> value) {
        Map<K, List<List<V>>> map = this.computeMap(stateFilePath);
        map.put(key, value);
    }

    @Override
    public synchronized boolean hasKey(String stateFilePath, K key) {
        Map<K, List<V>> map = this.computeMap(stateFilePath);
        return map.containsKey(key);
    }

    @Override
    public synchronized Map<K, List<V>> getEntries(String stateFilePath) {
        return this.computeMap(stateFilePath);
    }

    @Override
    public synchronized void remove(String stateFilePath, K key) {
        Map<K, List<V>> map = this.computeMap(stateFilePath);
        map.remove(key);
    }

    @Override
    public synchronized void close() {
        this.saveAllState();
        this.stateFileToMap.clear();
    }

    @Override
    public synchronized void deleteAllState() {
        this.stateFileToMap.forEach((stateFilePath, stateMap) -> {
            File stateFile = new File((String)stateFilePath);
            if (!stateFile.delete()) {
                log.warn("Could not delete {}", stateFilePath);
            }
        });
        this.stateFileToMap.clear();
    }

    @Override
    public synchronized void saveAllState() {
        this.stateFileToMap.forEach((stateFilePath, stateMap) -> {
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((String)stateFilePath, false)));){
                out.writeObject(stateMap);
            }
            catch (IOException e) {
                log.warn("Cannot save state map to {}", stateFilePath);
            }
        });
    }

    @Override
    public synchronized long count(String stateFilePath, K key) {
        Map<K, List<V>> map = this.computeMap(stateFilePath);
        List<V> values = map.get(key);
        if (values == null) {
            return 0L;
        }
        return values.size();
    }
}

