/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.idlabFunctions;

import be.ugent.knows.idlabFunctions.state.MapState;
import be.ugent.knows.idlabFunctions.state.SetState;
import be.ugent.knows.idlabFunctions.state.SimpleInMemoryMapState;
import be.ugent.knows.idlabFunctions.state.SimpleInMemorySetState;
import be.ugent.knows.idlabFunctions.state.SimpleInMemorySingleValueMapState;
import be.ugent.knows.util.Cache;
import be.ugent.knows.util.SearchParameters;
import be.ugent.knows.util.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.slugify.Slugify;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDLabFunctions {
    private static final Logger logger = LoggerFactory.getLogger(IDLabFunctions.class);
    private static final SetState<String> IMPLICIT_CREATE_STATE = new SimpleInMemorySetState<String>();
    private static final MapState<String, String, String> IMPLICIT_UPDATE_STATE = new SimpleInMemorySingleValueMapState<String, String>();
    private static final MapState<Boolean, String, Boolean> IMPLICIT_DELETE_STATE = new SimpleInMemorySingleValueMapState<String, Boolean>();
    private static final SetState<String> EXPLICIT_CREATE_STATE = new SimpleInMemorySetState<String>();
    private static final SetState<String> EXPLICIT_UPDATE_STATE = new SimpleInMemorySetState<String>();
    private static final SetState<String> EXPLICIT_DELETE_STATE = new SimpleInMemorySetState<String>();
    private static final MapState<List<String>, String, String> UNIQUE_IRI_STATE = new SimpleInMemoryMapState<String, String>();
    private static final SetState<String> UNIQUE_CREATE_IRI_STATE = new SimpleInMemorySetState<String>();
    private static final MapState<List<String>, String, String> UNIQUE_UPDATE_IRI_STATE = new SimpleInMemoryMapState<String, String>();
    public static final String MAGIC_MARKER = "!@#$%^&()_+";
    public static final String MAGIC_MARKER_ENCODED = "%21%40%23%24%25%5E%26%28%29_%2B";
    private static final boolean IMPLICIT_DELETE_SEEN_ID = true;
    private static final boolean IMPLICIT_DELETE_NOT_SEEN_ID = false;
    private static final Map<String, String> STATE_FILE_PATH_CACHE = new HashMap<String, String>();
    private static final Map<String, String> LOOKUP_STATE_MAP = new HashMap<String, String>();
    private static final Map<SearchParameters, String> MULTIPLE_LOOKUP_STATE_MAP = new HashMap<SearchParameters, String>();
    private static final Map<String, List<String[]>> CACHE = new HashMap<String, List<String[]>>();

    private static String resolveStateDirPath(String stateDirPathStr, String state_file) {
        String actualStateFilePathStr;
        String checkedStateDirPathStr;
        String result = STATE_FILE_PATH_CACHE.get(stateDirPathStr);
        if (result != null) {
            return result;
        }
        if (stateDirPathStr == null || stateDirPathStr.isEmpty()) {
            logger.debug("stateDirPathStr = NULL. Trying to read ifState property.");
            checkedStateDirPathStr = System.getProperty("ifState", "__tmp");
        } else {
            checkedStateDirPathStr = stateDirPathStr;
        }
        logger.debug("checkedStateDirPathStr = '{}'", (Object)checkedStateDirPathStr);
        if (checkedStateDirPathStr.equals("__tmp")) {
            actualStateFilePathStr = new File(System.getProperty("java.io.tmpdir"), state_file).getPath();
        } else if (checkedStateDirPathStr.equals("__working_dir")) {
            actualStateFilePathStr = new File(System.getProperty("user.dir"), state_file).getPath();
        } else {
            File stateDir = new File(checkedStateDirPathStr).getParentFile();
            if (!stateDir.exists()) {
                if (stateDir.mkdirs()) {
                    logger.debug("Created new state file directory '{}'", (Object)stateDir);
                } else {
                    logger.warn("Could not create new state directory {}! Using system temporary directory.", (Object)stateDir);
                    stateDir = new File(System.getProperty("java.io.tmpdir"));
                }
            }
            actualStateFilePathStr = new File(stateDir, new File(checkedStateDirPathStr).getName()).getPath();
        }
        logger.debug("actualStateFilePathStr = '{}'", (Object)actualStateFilePathStr);
        STATE_FILE_PATH_CACHE.put(stateDirPathStr, actualStateFilePathStr);
        return actualStateFilePathStr;
    }

    public static Map<SearchParameters, String> getMultipleLookupStateSet() {
        return Cache.getMultipleLookupStateMap();
    }

    public static Map<SearchParameters, String> getCache() {
        return Cache.getCache();
    }

    public static boolean stringContainsOtherString(String str, String otherStr, String delimiter) {
        String[] split = str.split(delimiter);
        List<String> list = Arrays.asList(split);
        return list.contains(otherStr);
    }

    public static boolean listContainsElement(List list, String str) {
        if (list != null) {
            return list.contains(str);
        }
        return false;
    }

    public static List<String> dbpediaSpotlight(String text, String endpoint) {
        if (!text.equals("")) {
            try {
                String inputLine;
                URL url = new URL(endpoint + "/annotate?text=" + URLEncoder.encode(text, StandardCharsets.UTF_8));
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.setRequestProperty("Accept", "application/json");
                con.setInstanceFollowRedirects(true);
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                in.close();
                con.disconnect();
                Object document = Configuration.defaultConfiguration().jsonProvider().parse(content.toString());
                return (List)JsonPath.parse((Object)document).read("$.Resources[*].@URI", new Predicate[0]);
            }
            catch (PathNotFoundException e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    public static String trueCondition(String bool, String value) {
        if (bool == null || !bool.equals("true")) {
            return null;
        }
        return value;
    }

    public static String decide(String input, String expected, String result) {
        if (input != null && input.equals(expected)) {
            return result;
        }
        return null;
    }

    public static boolean isNull(String input) {
        return input == null;
    }

    public static String getMIMEType(String filename) {
        if (filename == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("csv", "text/csv");
        map.put("json", "application/json");
        map.put("xml", "application/xml");
        map.put("nt", "application/n-triples");
        map.put("ttl", "text/turtle");
        map.put("nq", "application/n-quads");
        map.put("sql", "application/sql");
        int lastIndexOfPoint = filename.lastIndexOf(46);
        String extension = lastIndexOfPoint < 0 ? "" : filename.substring(Math.min(lastIndexOfPoint + 1, filename.length()));
        return map.getOrDefault(extension, null);
    }

    public static String readFile(String path) {
        try {
            logger.debug(Utils.getFile(path).toString());
            return Utils.fileToString(Utils.getFile(path));
        }
        catch (IOException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String random() {
        return UUID.randomUUID().toString();
    }

    public static String toUpperCaseURL(String test) {
        Object upperTest = test.toUpperCase();
        if (!((String)upperTest).startsWith("HTTP://")) {
            upperTest = "HTTP://" + (String)upperTest;
        }
        return upperTest;
    }

    public static boolean inRange(Double testNumber, Double from, Double to) {
        if (testNumber == null) {
            return false;
        }
        if (from == null && to == null) {
            return true;
        }
        if (from == null) {
            return testNumber < to;
        }
        if (to == null) {
            return testNumber >= from;
        }
        return testNumber >= from && testNumber < to;
    }

    public static String slugify(String str) {
        if (str != null) {
            Slugify slg = Slugify.builder().build();
            return slg.slugify(str);
        }
        return null;
    }

    public static boolean isSet(String valueParameter) {
        return valueParameter != null && !valueParameter.isEmpty();
    }

    public static boolean booleanMatch(String valueParameter, String regexParameter) {
        return valueParameter.matches(regexParameter);
    }

    private static String normalizeDateTimeStr(String dateStr, String pattern, String language, boolean includeTime) {
        try {
            Locale locale = new Locale(language);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, locale);
            if (includeTime) {
                LocalDateTime dateTime = LocalDateTime.parse(dateStr, formatter);
                return dateTime.format(DateTimeFormatter.ISO_DATE_TIME);
            }
            LocalDate date = LocalDate.parse(dateStr, formatter);
            return date.toString();
        }
        catch (Throwable e) {
            logger.error("{}; format pattern: \"{}\", input: \"{}\", language: \"{}\"", new Object[]{e.getMessage(), pattern, dateStr, language});
            return null;
        }
    }

    public static String normalizeDateWithLang(String dateStr, String pattern, String language) {
        return IDLabFunctions.normalizeDateTimeStr(dateStr, pattern, language, false);
    }

    public static String normalizeDate(String dateStr, String pattern) {
        return IDLabFunctions.normalizeDateWithLang(dateStr, pattern, Locale.getDefault().getLanguage());
    }

    public static String normalizeDateTimeWithLang(String dateTimeStr, String pattern, String language) {
        return IDLabFunctions.normalizeDateTimeStr(dateTimeStr, pattern, language, true);
    }

    public static String normalizeDateTime(String dateTimeStr, String pattern) {
        return IDLabFunctions.normalizeDateTimeWithLang(dateTimeStr, pattern, Locale.getDefault().getLanguage());
    }

    public static void saveState() {
        IMPLICIT_CREATE_STATE.saveAllState();
        IMPLICIT_UPDATE_STATE.saveAllState();
        IMPLICIT_DELETE_STATE.saveAllState();
        EXPLICIT_CREATE_STATE.saveAllState();
        EXPLICIT_UPDATE_STATE.saveAllState();
        EXPLICIT_DELETE_STATE.saveAllState();
        UNIQUE_IRI_STATE.saveAllState();
        UNIQUE_CREATE_IRI_STATE.saveAllState();
        UNIQUE_UPDATE_IRI_STATE.saveAllState();
    }

    public static void resetState() {
        IMPLICIT_CREATE_STATE.deleteAllState();
        IMPLICIT_UPDATE_STATE.deleteAllState();
        IMPLICIT_DELETE_STATE.deleteAllState();
        EXPLICIT_CREATE_STATE.deleteAllState();
        EXPLICIT_UPDATE_STATE.deleteAllState();
        EXPLICIT_DELETE_STATE.deleteAllState();
        UNIQUE_IRI_STATE.deleteAllState();
        UNIQUE_CREATE_IRI_STATE.deleteAllState();
        UNIQUE_UPDATE_IRI_STATE.deleteAllState();
    }

    public static void close() {
        try {
            IMPLICIT_CREATE_STATE.close();
            IMPLICIT_UPDATE_STATE.close();
            IMPLICIT_DELETE_STATE.close();
            EXPLICIT_CREATE_STATE.close();
            EXPLICIT_UPDATE_STATE.close();
            EXPLICIT_DELETE_STATE.close();
            UNIQUE_IRI_STATE.close();
            UNIQUE_CREATE_IRI_STATE.close();
            UNIQUE_UPDATE_IRI_STATE.close();
            LOOKUP_STATE_MAP.clear();
            STATE_FILE_PATH_CACHE.clear();
        }
        catch (Exception e) {
            logger.warn("Cannot close state.", (Throwable)e);
        }
    }

    public static String generateUniqueIRI(String iri, String watchedValueTemplate, Boolean isUnique, String stateDirPathStr) {
        if (isUnique == null || !isUnique.booleanValue()) {
            if (watchedValueTemplate == null) {
                logger.error("Watched value template is a required parameter but was not provided");
                return null;
            }
            String actualStateDirPathStr = IDLabFunctions.resolveStateDirPath(stateDirPathStr, "unique_iri_state");
            String watchedPropertyString = IDLabFunctions.sortWatchedProperties(watchedValueTemplate);
            Optional<Integer> indexOpt = UNIQUE_IRI_STATE.putAndReturnIndex(actualStateDirPathStr, iri, watchedPropertyString);
            return indexOpt.map(integer -> iri + "#" + Long.toString(integer.intValue(), 36)).orElse(null);
        }
        return iri;
    }

    public static String createUniqueIRI(String iri, Boolean isUnique, String stateDirPathStr) {
        if (isUnique == null || !isUnique.booleanValue()) {
            String actualStateDirPathStr = IDLabFunctions.resolveStateDirPath(stateDirPathStr, "unique_create_iri_state");
            if (!UNIQUE_CREATE_IRI_STATE.contains(actualStateDirPathStr, iri)) {
                UNIQUE_CREATE_IRI_STATE.add(actualStateDirPathStr, iri);
                return iri + "#0";
            }
            return null;
        }
        return iri;
    }

    public static String updateUniqueIRI(String iri, String watchedValueTemplate, Boolean isUnique, String stateDirPathStr) {
        if (isUnique == null || !isUnique.booleanValue()) {
            if (watchedValueTemplate == null) {
                logger.error("Watched value template is a required parameter but was not provided");
                return null;
            }
            String actualStateDirPathStr = IDLabFunctions.resolveStateDirPath(stateDirPathStr, "unique_update_iri_state");
            String watchedPropertyString = IDLabFunctions.sortWatchedProperties(watchedValueTemplate);
            if (UNIQUE_UPDATE_IRI_STATE.hasKey(actualStateDirPathStr, iri)) {
                Optional<Integer> indexOpt = UNIQUE_UPDATE_IRI_STATE.putAndReturnIndex(actualStateDirPathStr, iri, watchedPropertyString);
                return indexOpt.map(integer -> iri + "#" + Long.toString(integer.intValue(), 36)).orElse(null);
            }
            ArrayList<String> watchedProperties = new ArrayList<String>();
            watchedProperties.add(watchedPropertyString);
            UNIQUE_UPDATE_IRI_STATE.replace(actualStateDirPathStr, iri, watchedProperties);
            return null;
        }
        return iri;
    }

    public static String implicitCreate(String iri, String stateDirPathStr) {
        String actualStateDirPathStr = IDLabFunctions.resolveStateDirPath(stateDirPathStr, "implicit_create_state");
        if (iri == null || iri.contains(MAGIC_MARKER) || iri.contains(MAGIC_MARKER_ENCODED)) {
            return null;
        }
        if (IMPLICIT_CREATE_STATE.contains(actualStateDirPathStr, iri)) {
            return null;
        }
        IMPLICIT_CREATE_STATE.add(actualStateDirPathStr, iri);
        return iri;
    }

    public static String explicitCreate(String iri, String stateDirPathStr) {
        String actualStateDirPathStr = IDLabFunctions.resolveStateDirPath(stateDirPathStr, "explicit_create_state");
        if (iri == null || iri.contains(MAGIC_MARKER) || iri.contains(MAGIC_MARKER_ENCODED)) {
            return null;
        }
        if (EXPLICIT_CREATE_STATE.contains(actualStateDirPathStr, iri)) {
            return null;
        }
        EXPLICIT_CREATE_STATE.add(actualStateDirPathStr, iri);
        return iri;
    }

    public static String implicitUpdate(String iri, String watchedValueTemplate, String stateDirPathStr) {
        if (watchedValueTemplate == null) {
            logger.error("Watched value template is a required parameter but was not provided");
            return null;
        }
        if (iri == null || iri.contains(MAGIC_MARKER) || iri.contains(MAGIC_MARKER_ENCODED)) {
            return null;
        }
        String actualStateDirPathStr = IDLabFunctions.resolveStateDirPath(stateDirPathStr, "implicit_update_state");
        String watchedPropertyString = IDLabFunctions.sortWatchedProperties(watchedValueTemplate);
        if (!IMPLICIT_UPDATE_STATE.hasKey(actualStateDirPathStr, iri)) {
            IMPLICIT_UPDATE_STATE.replace(actualStateDirPathStr, iri, watchedPropertyString);
            return null;
        }
        Optional<Integer> index = IMPLICIT_UPDATE_STATE.replaceAndReturnIndex(actualStateDirPathStr, iri, watchedPropertyString);
        return index.isEmpty() ? null : iri;
    }

    public static String explicitUpdate(String iri, String stateDirPathStr) {
        if (iri == null || iri.contains(MAGIC_MARKER) || iri.contains(MAGIC_MARKER_ENCODED)) {
            return null;
        }
        String actualStateDirPathStr = IDLabFunctions.resolveStateDirPath(stateDirPathStr, "explicit_update_state");
        if (EXPLICIT_UPDATE_STATE.contains(actualStateDirPathStr, iri)) {
            return null;
        }
        EXPLICIT_UPDATE_STATE.add(actualStateDirPathStr, iri);
        return iri;
    }

    public static List<String> implicitDelete(String iri, String stateDirPathStr) {
        if (iri == null) {
            return null;
        }
        ArrayList<String> deletedIRIs = new ArrayList<String>();
        String actualStateDirPathStr = IDLabFunctions.resolveStateDirPath(stateDirPathStr, "implicit_delete_state");
        ArrayList<String> notSeen = new ArrayList<String>();
        if (iri.contains(MAGIC_MARKER) || iri.contains(MAGIC_MARKER_ENCODED)) {
            if (logger.isDebugEnabled()) {
                logger.debug("MAGIC MARKER");
                logger.debug("Entries: {}", (Object)IMPLICIT_DELETE_STATE.getEntries(actualStateDirPathStr).size());
            }
            for (Map.Entry<String, Boolean> entry : IMPLICIT_DELETE_STATE.getEntries(actualStateDirPathStr).entrySet()) {
                boolean value = entry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("IRI: {}: value: {}", (Object)entry.getKey(), (Object)value);
                }
                String key = entry.getKey();
                if (!value) {
                    deletedIRIs.add(key);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Haven't seen: {} since value {}", (Object)key, (Object)value);
                    continue;
                }
                notSeen.add(key);
            }
            for (String key : deletedIRIs) {
                IMPLICIT_DELETE_STATE.remove(actualStateDirPathStr, key);
            }
            for (String key : notSeen) {
                IMPLICIT_DELETE_STATE.put(actualStateDirPathStr, key, false);
            }
            return deletedIRIs.isEmpty() ? null : deletedIRIs;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Marking as seen: {}", (Object)iri);
        }
        IMPLICIT_DELETE_STATE.put(actualStateDirPathStr, iri, true);
        return null;
    }

    public static String explicitDelete(String iri, String stateDirPathStr) {
        if (iri == null || iri.contains(MAGIC_MARKER) || iri.contains(MAGIC_MARKER_ENCODED)) {
            return null;
        }
        String actualStateDirPathStr = IDLabFunctions.resolveStateDirPath(stateDirPathStr, "explicit_delete_state");
        if (EXPLICIT_DELETE_STATE.contains(actualStateDirPathStr, iri)) {
            return null;
        }
        EXPLICIT_DELETE_STATE.add(actualStateDirPathStr, iri);
        return iri;
    }

    static String sortWatchedProperties(String watchedValueTemplate) {
        Object[] propertyAndValues = watchedValueTemplate.split("&");
        Arrays.sort(propertyAndValues);
        return String.join((CharSequence)"&", (CharSequence[])propertyAndValues);
    }

    public static String concat(String str1, String str2, String delimiter) {
        String sep = delimiter == null ? "" : delimiter;
        return str1 + sep + str2;
    }

    public static String concatSequence(List<CharSequence> seq, String delimiter) {
        String sep = delimiter == null ? "" : delimiter;
        return String.join((CharSequence)sep, seq);
    }

    public static String jsonize(Object s) throws JsonProcessingException {
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        return ow.writeValueAsString(s);
    }

    public static String lookup(String searchString, String inputFile, Integer fromColumn, Integer toColumn) throws IOException, CsvValidationException {
        return IDLabFunctions.lookupWithDelimiter(searchString, inputFile, fromColumn, toColumn, ",");
    }

    public static String lookupWithDelimiter(String searchString, String inputFile, Integer fromColumn, Integer toColumn, String delimiter) throws IOException, CsvValidationException {
        String result;
        CSVReader reader = IDLabFunctions.createReader(inputFile, delimiter);
        if (reader != null) {
            String[] nextLine = reader.readNext();
            if (fromColumn < 0 || toColumn < 0 || fromColumn >= nextLine.length || toColumn >= nextLine.length) {
                logger.error("Column index out of boundaries; inputFile: \"{}\", fromColumn: \"{}\", toColumn: \"{}\"", new Object[]{inputFile, fromColumn, toColumn});
                return null;
            }
            while (nextLine != null) {
                if (!LOOKUP_STATE_MAP.containsKey(nextLine[fromColumn])) {
                    LOOKUP_STATE_MAP.put(nextLine[fromColumn], nextLine[toColumn]);
                }
                nextLine = reader.readNext();
            }
            reader.close();
        }
        if ((result = LOOKUP_STATE_MAP.get(searchString)) == null) {
            logger.error("The searchString is not found; searchString: \"{}\", inputFile: \"{}\", fromColumn: \"{}\"", new Object[]{searchString, inputFile, fromColumn});
        }
        return result;
    }

    public static String multipleLookup(List<String> searchValues, List<Integer> fromColumns, String inputFile, Integer toColumn, String delimiter) throws IOException, CsvValidationException {
        SearchParameters pair = new SearchParameters(searchValues, fromColumns, inputFile);
        if (MULTIPLE_LOOKUP_STATE_MAP.containsKey(pair)) {
            return MULTIPLE_LOOKUP_STATE_MAP.get(pair);
        }
        if (!CACHE.containsKey(inputFile) || CACHE.get(inputFile) == null) {
            CSVReader reader = IDLabFunctions.createReader(inputFile, delimiter);
            return Cache.fileToCache(searchValues, fromColumns, inputFile, toColumn, reader);
        }
        return Cache.readFromCache(searchValues, fromColumns, inputFile, toColumn);
    }

    public static String multipleLookup(String firstStr, String secondStr, String thirdStr, String fourthStr, String fifthStr, String sixthStr, Integer first, Integer second, Integer third, Integer fourth, Integer fifth, Integer sixth, String inputFile, Integer toColumn, String delimiter) throws IOException, CsvValidationException {
        List<String> values = new ArrayList<String>(Arrays.asList(firstStr, secondStr, thirdStr, fourthStr, fifthStr, sixthStr)).stream().filter(Objects::nonNull).collect(Collectors.toList());
        List<Integer> indexes = new ArrayList<Integer>(Arrays.asList(first, second, third, fourth, fifth, sixth)).stream().filter(Objects::nonNull).collect(Collectors.toList());
        return IDLabFunctions.multipleLookup(values, indexes, inputFile, toColumn, delimiter);
    }

    private static CSVReader createReader(String inputFile, String delimiter) throws IOException {
        if (inputFile != null) {
            InputStream inputStream = Files.newInputStream(new File(inputFile).toPath(), new OpenOption[0]);
            CSVParser parser = new CSVParserBuilder().withSeparator(delimiter.charAt(0)).withIgnoreQuotations(true).build();
            return new CSVReaderBuilder((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8)).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).withCSVParser((ICSVParser)parser).build();
        }
        return null;
    }
}

