/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static File getFile(String path) throws IOException {
        return Utils.getFile(path, null);
    }

    public static File getFile(String path, File basePath) throws IOException {
        File f = new File(path);
        if (f.isAbsolute()) {
            if (f.exists()) {
                return f;
            }
            throw new FileNotFoundException();
        }
        if (basePath == null) {
            try {
                basePath = new File(System.getProperty("user.dir"));
            }
            catch (Exception e) {
                throw new FileNotFoundException();
            }
        }
        logger.debug("Looking for file " + path + " in basePath " + basePath);
        f = new File(basePath, path);
        if (f.exists()) {
            return f;
        }
        logger.debug("File " + path + " not found in " + basePath);
        logger.debug("Looking for file " + path + " in " + basePath + "/../");
        f = new File(basePath, "../" + path);
        if (f.exists()) {
            return f;
        }
        logger.debug("File " + path + " not found in " + basePath);
        logger.debug("Looking for file " + path + " in the resources directory");
        try {
            return Utils.getResourceAsFile(path);
        }
        catch (IOException iOException) {
            logger.debug("File " + path + " not found in the resources directory");
            throw new FileNotFoundException(path);
        }
    }

    static File getResourceAsFile(String resource) throws IOException {
        ClassLoader cl = Utils.class.getClassLoader();
        URL resourceUrl = cl.getResource(resource);
        if (resourceUrl == null) {
            throw new IOException("Resource file " + resource + " doesn't exist");
        }
        if ("file".equals(resourceUrl.getProtocol())) {
            try {
                URI uri = resourceUrl.toURI();
                return new File(uri);
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to get file through class loader: " + cl, e);
            }
        }
        throw new IOException("Unable to get file through class loader: " + cl);
    }

    public static String fileToString(File file) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Files.copy(file.toPath(), os);
        return os.toString(StandardCharsets.UTF_8);
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files != null) {
                boolean allFilesDeleted = true;
                for (File file : files) {
                    if (file.isDirectory()) {
                        Utils.deleteDirectory(file);
                    }
                    if (!file.isFile() || file.delete()) continue;
                    logger.warn("Could not delete {}", (Object)file.getCanonicalPath());
                    allFilesDeleted = false;
                }
                if (allFilesDeleted && !directory.delete()) {
                    allFilesDeleted = false;
                }
                if (!allFilesDeleted) {
                    throw new IOException("Could not delete directory " + directory);
                }
            }
        } else {
            logger.warn("{} is not a directory; deleting nothing.", (Object)directory);
        }
    }
}

