/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.idlabFunctions.state;

import be.ugent.knows.idlabFunctions.state.MapState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInMemoryMapState
implements MapState {
    private static final Logger log = LoggerFactory.getLogger(SimpleInMemoryMapState.class);
    private static final Map<String, Map<String, List<String>>> stateFileToMap = new HashMap<String, Map<String, List<String>>>();

    private synchronized Map<String, List<String>> computeMap(String stateFilePath) {
        Map map = stateFileToMap.computeIfAbsent(stateFilePath, mapKey -> {
            File stateFile = new File(stateFilePath);
            Map newMap = new HashMap();
            if (stateFile.exists() && stateFile.isFile() && stateFile.canRead()) {
                try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(stateFilePath)));){
                    newMap = (Map)in.readObject();
                }
                catch (IOException | ClassNotFoundException e) {
                    log.warn("Cannot load state map from file {}. Creating empty map!", (Object)stateFilePath);
                }
            }
            return newMap;
        });
        return map;
    }

    @Override
    public synchronized String put(String stateFilePath, String key, String value) {
        Map<String, List<String>> map = this.computeMap(stateFilePath);
        List values = map.computeIfAbsent(key, k -> new ArrayList());
        if (values.isEmpty()) {
            values.add(value);
            map.put(key, values);
            return null;
        }
        if (values.contains(value)) {
            return (String)values.get(values.size() - 1);
        }
        String returnValue = (String)values.get(values.size() - 1);
        values.add(value);
        map.put(key, values);
        return returnValue;
    }

    @Override
    public synchronized Optional<Integer> putAndReturnIndex(String stateFilePath, String key, String value) {
        Map<String, List<String>> map = this.computeMap(stateFilePath);
        List values = map.computeIfAbsent(key, k -> new ArrayList(4));
        if (values.isEmpty()) {
            values.add(value);
            map.put(key, values);
            return Optional.of(0);
        }
        if (values.contains(value)) {
            return Optional.empty();
        }
        values.add(value);
        map.put(key, values);
        return Optional.of(values.size() - 1);
    }

    @Override
    public synchronized Optional<Integer> replaceAndReturnIndex(String stateFilePath, String key, String value) {
        Map<String, List<String>> map = this.computeMap(stateFilePath);
        List values = map.computeIfAbsent(key, k -> new ArrayList(1));
        if (values.isEmpty()) {
            values.add(value);
            map.put(key, values);
            return Optional.of(0);
        }
        if (values.contains(value)) {
            return Optional.empty();
        }
        ArrayList<String> newValues = new ArrayList<String>();
        newValues.add(value);
        map.put(key, newValues);
        return Optional.of(newValues.size() - 1);
    }

    @Override
    public synchronized void replace(String stateFilePath, String key, List<String> value) {
        Map<String, List<String>> map = this.computeMap(stateFilePath);
        map.put(key, value);
    }

    @Override
    public synchronized boolean hasKey(String stateFilePath, String key) {
        Map<String, List<String>> map = this.computeMap(stateFilePath);
        List values = map.computeIfAbsent(key, k -> new ArrayList(4));
        return !values.isEmpty();
    }

    @Override
    public synchronized Map<String, List<String>> getEntries(String stateFilePath) {
        Map<String, List<String>> map = this.computeMap(stateFilePath);
        return map;
    }

    @Override
    public synchronized void remove(String stateFilePath, String key) {
        Map<String, List<String>> map = this.computeMap(stateFilePath);
        map.remove(key);
    }

    @Override
    public synchronized void close() {
        this.saveAllState();
        stateFileToMap.clear();
    }

    @Override
    public synchronized void deleteAllState() {
        stateFileToMap.forEach((stateFilePath, stateMap) -> {
            File stateFile = new File((String)stateFilePath);
            if (!stateFile.delete()) {
                log.warn("Could not delete {}", stateFilePath);
            }
        });
        stateFileToMap.clear();
    }

    @Override
    public synchronized void saveAllState() {
        stateFileToMap.forEach((stateFilePath, stateMap) -> {
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((String)stateFilePath, false)));){
                out.writeObject(stateMap);
            }
            catch (IOException e) {
                log.warn("Cannot save state map to {}", stateFilePath);
            }
        });
    }

    @Override
    public synchronized long count(String stateFilePath, String key) {
        if (stateFileToMap.containsKey(stateFilePath)) {
            Map<String, List<String>> map = stateFileToMap.get(stateFilePath);
            List<String> values = map.get(key);
            if (values == null) {
                return 0L;
            }
            return values.size();
        }
        return 0L;
    }
}

