/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.idlabFunctions;

import be.ugent.knows.util.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.slugify.Slugify;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDLabFunctions {
    private static final Logger logger = LoggerFactory.getLogger(IDLabFunctions.class);
    private static Map<String, Map<String, String>> LDES_FILE_STATE_MAP = new HashMap<String, Map<String, String>>();
    private static Path STATE_DIR = null;
    private static final Map<String, String> LOOKUP_STATE_MAP = new HashMap<String, String>();
    private static String LOOKUP_STATE_INPUTFILE = "";
    private static Integer LOOKUP_STATE_FROM_COLUMN = -1;
    private static Integer LOOKUP_STATE_TO_COLUMN = -1;

    public static boolean stringContainsOtherString(String str, String otherStr, String delimiter) {
        String[] split = str.split(delimiter);
        List<String> list = Arrays.asList(split);
        return list.contains(otherStr);
    }

    public static boolean listContainsElement(List list, String str) {
        if (list != null) {
            return list.contains(str);
        }
        return false;
    }

    public static List<String> dbpediaSpotlight(String text, String endpoint) {
        if (!text.equals("")) {
            try {
                String inputLine;
                URL url = new URL(endpoint + "/annotate?text=" + URLEncoder.encode(text, "UTF-8"));
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.setRequestProperty("Accept", "application/json");
                con.setInstanceFollowRedirects(true);
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                in.close();
                con.disconnect();
                Object document = Configuration.defaultConfiguration().jsonProvider().parse(content.toString());
                return (List)JsonPath.parse((Object)document).read("$.Resources[*].@URI", new Predicate[0]);
            }
            catch (PathNotFoundException e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    public static String trueCondition(String bool, String value) {
        if (bool == null || !bool.equals("true")) {
            return null;
        }
        return value;
    }

    public static String decide(String input, String expected, String result) {
        if (input != null && input.equals(expected)) {
            return result;
        }
        return null;
    }

    public static boolean isNull(String input) {
        return input == null;
    }

    public static String getMIMEType(String filename) {
        if (filename == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("csv", "text/csv");
        map.put("json", "application/json");
        map.put("xml", "application/xml");
        map.put("nt", "application/n-triples");
        map.put("ttl", "text/turtle");
        map.put("nq", "application/n-quads");
        map.put("sql", "application/sql");
        int lastIndexOfPoint = filename.lastIndexOf(46);
        String extension = lastIndexOfPoint < 0 ? "" : filename.substring(Math.min(lastIndexOfPoint + 1, filename.length()));
        return map.getOrDefault(extension, null);
    }

    public static String readFile(String path) {
        try {
            logger.debug(Utils.getFile(path).toString());
            return Utils.fileToString(Utils.getFile(path));
        }
        catch (IOException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String random() {
        return UUID.randomUUID().toString();
    }

    public static String toUpperCaseURL(String test) {
        String upperTest = test.toUpperCase();
        if (!upperTest.startsWith("HTTP://")) {
            upperTest = "HTTP://" + upperTest;
        }
        return upperTest;
    }

    public static boolean inRange(Double testNumber, Double from, Double to) {
        if (testNumber == null) {
            return false;
        }
        if (from == null && to == null) {
            return true;
        }
        if (from == null) {
            return testNumber < to;
        }
        if (to == null) {
            return testNumber >= from;
        }
        return testNumber >= from && testNumber < to;
    }

    public static String slugify(String str) {
        if (str != null) {
            Slugify slg = new Slugify();
            return slg.slugify(str);
        }
        return null;
    }

    public static boolean isSet(String valueParameter) {
        return valueParameter != null && !valueParameter.isEmpty();
    }

    public static boolean booleanMatch(String valueParameter, String regexParameter) {
        return valueParameter.matches(regexParameter);
    }

    private static String normalizeDateTimeStr(String dateStr, String pattern, String language, boolean includeTime) {
        try {
            Locale locale = new Locale(language);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, locale);
            if (includeTime) {
                LocalDateTime dateTime = LocalDateTime.parse(dateStr, formatter);
                return dateTime.format(DateTimeFormatter.ISO_DATE_TIME);
            }
            LocalDate date = LocalDate.parse(dateStr, formatter);
            return date.toString();
        }
        catch (Throwable e) {
            logger.error("{}; format pattern: \"{}\", input: \"{}\", language: \"{}\"", new Object[]{e.getMessage(), pattern, dateStr, language});
            return null;
        }
    }

    public static String normalizeDateWithLang(String dateStr, String pattern, String language) {
        return IDLabFunctions.normalizeDateTimeStr(dateStr, pattern, language, false);
    }

    public static String normalizeDate(String dateStr, String pattern) {
        return IDLabFunctions.normalizeDateWithLang(dateStr, pattern, Locale.getDefault().getLanguage());
    }

    public static String normalizeDateTimeWithLang(String dateTimeStr, String pattern, String language) {
        return IDLabFunctions.normalizeDateTimeStr(dateTimeStr, pattern, language, true);
    }

    public static String normalizeDateTime(String dateTimeStr, String pattern) {
        return IDLabFunctions.normalizeDateTimeWithLang(dateTimeStr, pattern, Locale.getDefault().getLanguage());
    }

    private static Map<String, String> parsePropertyValueTemplate(Optional<String> watchedValueTemplate) {
        HashMap<String, String> result = new HashMap<String, String>();
        String watchedVal = watchedValueTemplate.orElse("");
        if (watchedVal.length() > 0) {
            Arrays.stream(watchedVal.split("&")).map(s -> s.split("=")).filter(sArr -> ((String[])sArr).length == 2).forEach(sArr -> result.put(sArr[0], sArr[1]));
        }
        return result;
    }

    private static String updateStatePropertyRecord(Map<String, String> watchedMap, String hexKey, AtomicBoolean found, AtomicBoolean isDifferent, boolean isUnique, String storedStateRecord) {
        if (isUnique) {
            if (storedStateRecord.equals(hexKey)) {
                found.set(true);
            }
            return storedStateRecord;
        }
        int split_idx = storedStateRecord.indexOf(58);
        if (split_idx == -1) {
            return storedStateRecord;
        }
        String storedHexKey = storedStateRecord.substring(0, split_idx);
        if (!storedHexKey.equals(hexKey)) {
            return storedStateRecord;
        }
        found.set(true);
        List propertyValPairs = Arrays.stream(storedStateRecord.substring(split_idx + 1).split("&")).map(str -> {
            String[] propVal = str.split("=");
            String property = propVal[0];
            String storeVal = "NULL";
            try {
                storeVal = propVal[1];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            String watchedVal = watchedMap.getOrDefault(property, null);
            if (watchedVal != null && !watchedVal.equals(storeVal)) {
                isDifferent.set(true);
                storeVal = watchedVal;
            }
            return String.format("%s=%s", property, storeVal);
        }).collect(Collectors.toList());
        return String.format("%s:%s", storedHexKey, String.join((CharSequence)"&", propertyValPairs));
    }

    private static Path getStateFilePath(String stateDirPathStr, int m_buckets, int templateHash) {
        String hexBucketFileName = Integer.toHexString(templateHash % m_buckets);
        return Paths.get(String.format("%s/%s.log", stateDirPathStr, hexBucketFileName), new String[0]);
    }

    public static String generateUniqueIRIOLD(String template, String watchedValueTemplate, Boolean isUnique, String stateDirPathStr) {
        int m_buckets = 10;
        Map<String, String> watchedMap = IDLabFunctions.parsePropertyValueTemplate(Optional.ofNullable(watchedValueTemplate));
        int templateHash = template.hashCode();
        Path stateFilePath = IDLabFunctions.getStateFilePath(stateDirPathStr, m_buckets, templateHash);
        String hexKey = Integer.toHexString(templateHash);
        AtomicBoolean found = new AtomicBoolean(false);
        AtomicBoolean isDifferent = new AtomicBoolean(false);
        String output = null;
        try {
            List outputRecords;
            Files.createDirectories(Paths.get(stateDirPathStr, new String[0]), new FileAttribute[0]);
            if (Files.notExists(stateFilePath, new LinkOption[0])) {
                Files.createFile(stateFilePath, new FileAttribute[0]);
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(stateFilePath.toFile()));){
                outputRecords = reader.lines().map(s -> IDLabFunctions.updateStatePropertyRecord(watchedMap, hexKey, found, isDifferent, isUnique, s)).collect(Collectors.toList());
            }
            if (!found.get()) {
                String hexedStateRecord = isUnique != false ? hexKey : String.format("%s:%s", hexKey, watchedValueTemplate);
                outputRecords.add(hexedStateRecord);
            }
            var14_14 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(stateFilePath.toFile()));){
                for (String line : outputRecords) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (Throwable throwable) {
                var14_14 = throwable;
                throw throwable;
            }
            output = IDLabFunctions.getOutput(template, isUnique, found, isDifferent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    private static String getOutput(String template, Boolean isUnique, AtomicBoolean found, AtomicBoolean isDifferent) {
        String output = null;
        if (isDifferent.get() || !found.get()) {
            logger.debug("Update found! Generating IRI...");
            if (isUnique.booleanValue()) {
                output = template;
            } else {
                OffsetDateTime now = OffsetDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
                output = String.format("%s#%s", template, formatter.format(now));
            }
        }
        return output;
    }

    private static void initStateFile(Path stateDirPath) {
        try (Stream<Path> statePaths = Files.find(stateDirPath, 1, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);){
            Stream<AbstractMap.SimpleImmutableEntry> readers = statePaths.map(path -> {
                try {
                    return new AbstractMap.SimpleImmutableEntry<Path, BufferedReader>((Path)path, new BufferedReader(new FileReader(path.toFile())));
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }).filter(Objects::nonNull);
            readers.forEach(entry -> {
                try (BufferedReader bReader = (BufferedReader)entry.getValue();){
                    String fileName = ((Path)entry.getKey()).toString();
                    bReader.lines().forEach(line -> {
                        String[] pairs = line.split(":");
                        String key = pairs[0];
                        String val = null;
                        try {
                            val = pairs[1];
                        }
                        catch (IndexOutOfBoundsException e) {
                            e.printStackTrace();
                        }
                        LDES_FILE_STATE_MAP.computeIfAbsent(fileName, k -> new HashMap()).put(key, val);
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveState() throws IOException {
        if (Objects.nonNull(STATE_DIR)) {
            Files.createDirectories(STATE_DIR, new FileAttribute[0]);
            for (Map.Entry<String, Map<String, String>> entry : LDES_FILE_STATE_MAP.entrySet()) {
                Path file = Paths.get(entry.getKey(), new String[0]);
                Map<String, String> storedMap = entry.getValue();
                if (Files.notExists(file, new LinkOption[0])) {
                    Files.createFile(file, new FileAttribute[0]);
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(file.toFile()));
                Throwable throwable = null;
                try {
                    for (Map.Entry<String, String> record : storedMap.entrySet()) {
                        String line = record.getKey();
                        if (record.getValue() != null) {
                            line = String.format("%s:%s", record.getKey(), record.getValue());
                        }
                        writer.write(line);
                        writer.newLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
        }
    }

    public static void resetState() {
        LDES_FILE_STATE_MAP = new HashMap<String, Map<String, String>>();
        STATE_DIR = null;
    }

    public static String generateUniqueIRI(String template, String watchedValueTemplate, Boolean isUnique, String stateDirPathStr) {
        if (STATE_DIR == null) {
            STATE_DIR = Paths.get(stateDirPathStr, new String[0]);
            IDLabFunctions.initStateFile(STATE_DIR);
        }
        int m_buckets = 10;
        Optional<String> watchedValueOption = Optional.ofNullable(watchedValueTemplate);
        Map<String, String> watchedMap = IDLabFunctions.parsePropertyValueTemplate(watchedValueOption);
        int templateHash = template.hashCode();
        String stateFilePathStr = IDLabFunctions.getStateFilePath(stateDirPathStr, m_buckets, templateHash).toString();
        String hexKey = Integer.toHexString(templateHash);
        AtomicBoolean found = new AtomicBoolean(false);
        AtomicBoolean isDifferent = new AtomicBoolean(false);
        Map keyValMap = LDES_FILE_STATE_MAP.computeIfAbsent(stateFilePathStr, f -> new HashMap());
        if (keyValMap.containsKey(hexKey)) {
            found.set(true);
            String storedProp = (String)keyValMap.get(hexKey);
            Map<String, String> storedPropMap = IDLabFunctions.parsePropertyValueTemplate(Optional.ofNullable(storedProp));
            for (Map.Entry<String, String> kv : watchedMap.entrySet()) {
                String storedVal;
                String prop = kv.getKey();
                String val = kv.getValue();
                if (val.equals(storedVal = (String)storedPropMap.getOrDefault(prop, null))) continue;
                isDifferent.set(true);
            }
        }
        keyValMap.put(hexKey, watchedValueTemplate);
        return IDLabFunctions.getOutput(template, isUnique, found, isDifferent);
    }

    public static String concat(String str1, String str2, String delimiter) {
        String sep = delimiter == null ? "" : delimiter;
        return str1 + sep + str2;
    }

    public static String jsonize(Object s) throws JsonProcessingException {
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        return ow.writeValueAsString(s);
    }

    public static String lookupWithDelimiter(String searchString, String inputFile, Integer fromColumn, Integer toColumn, String delimiter) throws IOException, CsvValidationException {
        String result;
        if (!(LOOKUP_STATE_INPUTFILE.equals(inputFile) && LOOKUP_STATE_FROM_COLUMN.equals(fromColumn) && LOOKUP_STATE_TO_COLUMN.equals(toColumn))) {
            LOOKUP_STATE_INPUTFILE = inputFile;
            LOOKUP_STATE_FROM_COLUMN = fromColumn;
            LOOKUP_STATE_TO_COLUMN = toColumn;
            LOOKUP_STATE_MAP.clear();
            FileInputStream inputStream = new FileInputStream(new File(inputFile));
            CSVParser parser = new CSVParserBuilder().withSeparator(delimiter.charAt(0)).withIgnoreQuotations(true).build();
            CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8)).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).withCSVParser((ICSVParser)parser).build();
            String[] nextLine = reader.readNext();
            if (fromColumn < 0 || toColumn < 0 || fromColumn >= nextLine.length || toColumn >= nextLine.length) {
                logger.error("Column index out of boundries; inputFile: \"{}\", fromColumn: \"{}\", toColumn: \"{}\"", new Object[]{inputFile, fromColumn, toColumn});
                return null;
            }
            while (nextLine != null) {
                if (!LOOKUP_STATE_MAP.containsKey(nextLine[fromColumn])) {
                    LOOKUP_STATE_MAP.put(nextLine[fromColumn], nextLine[toColumn]);
                }
                nextLine = reader.readNext();
            }
            reader.close();
        }
        if ((result = LOOKUP_STATE_MAP.get(searchString)) == null) {
            logger.error("The searchString is not found; searchString: \"{}\", inputFile: \"{}\", fromColumn: \"{}\"", new Object[]{searchString, inputFile, fromColumn});
        }
        return result;
    }

    public static String lookup(String searchString, String inputFile, Integer fromColumn, Integer toColumn) throws IOException, CsvValidationException {
        return IDLabFunctions.lookupWithDelimiter(searchString, inputFile, fromColumn, toColumn, ",");
    }
}

