/*
 * Decompiled with CFR 0.152.
 */
package io.fno.grel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DateFunctions {
    private static final Map<String, TemporalField> grelPartToFieldPos = new HashMap<String, TemporalField>();

    public static LocalDateTime now() {
        return LocalDateTime.now(Clock.systemUTC());
    }

    public static Date toDate(String dateStr, String pattern) throws ParseException {
        SimpleDateFormat dateFormat;
        SimpleDateFormat simpleDateFormat = dateFormat = pattern == null ? new SimpleDateFormat() : new SimpleDateFormat(pattern);
        if (pattern == null || !pattern.contains("z") && !pattern.contains("Z") && !pattern.contains("X")) {
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return dateFormat.parse(dateStr);
    }

    public static String toString(Date date, String pattern) {
        SimpleDateFormat dateFormat;
        SimpleDateFormat simpleDateFormat = dateFormat = pattern == null ? new SimpleDateFormat() : new SimpleDateFormat(pattern);
        if (pattern == null || !pattern.contains("z") && !pattern.contains("Z") && !pattern.contains("X")) {
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static long diff(Date startDate, Date endDate, String timeUnit) {
        Date d2;
        Date d1;
        TemporalUnit parsedTimeUnit = DateFunctions.convertToTemporalUnit(timeUnit);
        if (endDate.before(startDate)) {
            d1 = endDate;
            d2 = startDate;
        } else {
            d1 = startDate;
            d2 = endDate;
        }
        LocalDateTime dt1 = DateFunctions.toLocalDateTime(d1);
        LocalDateTime dt2 = DateFunctions.toLocalDateTime(d2);
        return parsedTimeUnit.between(dt1, dt2);
    }

    public static Date inc(Date date, long value, String timeUnit) {
        return DateFunctions.toDate(DateFunctions.inc(DateFunctions.toLocalDateTime(date), value, timeUnit));
    }

    public static LocalDateTime inc(LocalDateTime dateTime, long value, String timeUnit) {
        TemporalUnit tu = DateFunctions.convertToTemporalUnit(timeUnit);
        if (value >= 0L) {
            return dateTime.plus(value, tu);
        }
        return dateTime.minus(-value, tu);
    }

    public static Object datePart(Date date, String field) {
        String uField = field.toUpperCase();
        if (uField.equals("TIME")) {
            return date.getTime();
        }
        TemporalField temporalField = grelPartToFieldPos.get(uField);
        if (temporalField == null) {
            temporalField = ChronoField.valueOf(uField);
        }
        long result = DateFunctions.toLocalDateTime(date).get(temporalField);
        if (temporalField.equals(ChronoField.DAY_OF_WEEK)) {
            return DayOfWeek.values()[(int)result].getDisplayName(TextStyle.FULL, Locale.getDefault());
        }
        return result;
    }

    private static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.of("UTC")).toLocalDateTime();
    }

    private static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.of("UTC")).toInstant());
    }

    private static TemporalUnit convertToTemporalUnit(String timeUnit) {
        String tu = timeUnit.toUpperCase();
        if (tu.equals("MILLISECONDS")) {
            tu = "MILLIS";
        } else if (tu.equalsIgnoreCase("NANOSECONDS")) {
            tu = "NANOS";
        }
        return ChronoUnit.valueOf(tu.toUpperCase(Locale.ROOT));
    }

    static {
        grelPartToFieldPos.put("YEARS", ChronoField.YEAR);
        grelPartToFieldPos.put("MONTHS", ChronoField.MONTH_OF_YEAR);
        grelPartToFieldPos.put("MONTH", ChronoField.MONTH_OF_YEAR);
        grelPartToFieldPos.put("WEEK", ChronoField.ALIGNED_WEEK_OF_MONTH);
        grelPartToFieldPos.put("WEEKS", ChronoField.ALIGNED_WEEK_OF_MONTH);
        grelPartToFieldPos.put("W", ChronoField.ALIGNED_WEEK_OF_MONTH);
        grelPartToFieldPos.put("WEEKDAY", ChronoField.DAY_OF_WEEK);
        grelPartToFieldPos.put("HOURS", ChronoField.HOUR_OF_DAY);
        grelPartToFieldPos.put("H", ChronoField.HOUR_OF_DAY);
        grelPartToFieldPos.put("MINUTE", ChronoField.MINUTE_OF_HOUR);
        grelPartToFieldPos.put("MINUTES", ChronoField.MINUTE_OF_HOUR);
        grelPartToFieldPos.put("SECONDS", ChronoField.SECOND_OF_MINUTE);
        grelPartToFieldPos.put("SEC", ChronoField.SECOND_OF_MINUTE);
        grelPartToFieldPos.put("S", ChronoField.SECOND_OF_MINUTE);
        grelPartToFieldPos.put("MILLISECONDS", ChronoField.MILLI_OF_SECOND);
        grelPartToFieldPos.put("MS", ChronoField.MILLI_OF_SECOND);
        grelPartToFieldPos.put("NANOSECONDS", ChronoField.NANO_OF_SECOND);
        grelPartToFieldPos.put("NANO", ChronoField.NANO_OF_SECOND);
        grelPartToFieldPos.put("NANOS", ChronoField.NANO_OF_SECOND);
        grelPartToFieldPos.put("N", ChronoField.NANO_OF_SECOND);
    }
}

