/*
 * Decompiled with CFR 0.152.
 */
package io.fno.grel;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.language.ColognePhonetic;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class StringFunctions {
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";

    public static Integer length(String s) {
        return s.length();
    }

    public static String toString(Object valueParameter) {
        if (valueParameter == null) {
            return "null";
        }
        return valueParameter.toString();
    }

    public static Boolean startsWith(String s, String sub) {
        return s.startsWith(sub);
    }

    public static Boolean endsWith(String s, String sub) {
        return s.endsWith(sub);
    }

    public static Boolean contains(String s, String sub) {
        return s.contains(sub);
    }

    public static String toLowercase(String s) {
        return s.toLowerCase();
    }

    public static String toUppercase(String s) {
        return s.toUpperCase();
    }

    public static String toTitlecase(String s) {
        return WordUtils.capitalizeFully((String)s);
    }

    public static String trim(String s) {
        return s.trim();
    }

    public static String strip(String s) {
        return StringFunctions.trim(s);
    }

    public static String chomp(String s, String sep) {
        return StringUtils.chomp((String)s, (String)sep);
    }

    public static String substring(String s, Integer from) {
        return s.substring(from);
    }

    public static String substring(String s, Integer from, Integer to) {
        return s.substring(from, to);
    }

    public static String slice(String s, Integer from, Integer to) {
        return StringFunctions.substring(s, from, to);
    }

    public static String slice(String s, Integer from) {
        return StringFunctions.substring(s, from);
    }

    public static String get(String s, Integer from, Integer to) {
        return StringFunctions.substring(s, from, to);
    }

    public static String get(String s, Integer from) {
        return StringFunctions.substring(s, from);
    }

    public static Integer indexOf(String s, String sub) {
        return s.indexOf(sub);
    }

    public static Integer lastIndexOf(String s, String sub) {
        return s.lastIndexOf(sub);
    }

    public static String replace(String s, String f, String r) {
        return s.replaceAll(f, r);
    }

    public static String replaceChars(String s, String f, String r) throws Exception {
        if (f.length() > r.length()) {
            throw new Exception("You must provide as many replacement characters as target characters.");
        }
        for (int i = 0; i < f.length(); ++i) {
            char find = f.charAt(i);
            char replace = r.charAt(i);
            s = s.replace(find, replace);
        }
        return s;
    }

    public static String[] match(String s, String p) {
        ArrayList<String> allMatches = new ArrayList<String>();
        Matcher m = Pattern.compile(p).matcher(s);
        while (m.find()) {
            allMatches.add(m.group());
        }
        return (String[])allMatches.toArray();
    }

    public static Integer toNumber(Object o) {
        if (o.getClass().equals(Integer.class)) {
            return (Integer)o;
        }
        String str = o.toString();
        return Integer.parseInt(str);
    }

    public static List<String> split(String s, String sep) {
        return Arrays.asList(s.split(sep));
    }

    public static String[] splitByLengths(String s, int ... numbers) {
        ArrayList<String> output = new ArrayList<String>();
        int i = 0;
        for (int n : numbers) {
            output.add(s.substring(i, i + n));
            i += n;
        }
        return output.toArray(new String[0]);
    }

    public static String[] smartSplit(String s) {
        String sep = StringUtils.countMatches((String)s, (String)"\t") < StringUtils.countMatches((String)s, (String)",") ? "," : "\t";
        return StringFunctions.smartSplit(s, sep);
    }

    public static String[] smartSplit(String s, String sep) {
        return s.split(sep);
    }

    public static String[] splitByCharType(String value) {
        return StringUtils.splitByCharacterType((String)value);
    }

    public static String[] _partition(String s, String frag, Boolean omitFragment, Boolean last) {
        ArrayList<String> output = new ArrayList<String>();
        int offset = 0;
        int index = last != false ? s.indexOf(frag) : s.lastIndexOf(frag);
        if (index == -1) {
            return new String[]{s, "", ""};
        }
        output.add(s.substring(0, index));
        if (!omitFragment.booleanValue()) {
            output.add(frag);
            offset += frag.length();
        }
        output.add(s.substring(index + offset));
        return output.toArray(new String[0]);
    }

    public static String[] partition(String s, String frag) {
        return StringFunctions.partition(s, frag, false);
    }

    public static String[] partition(String s, String frag, Boolean omitFragment) {
        return StringFunctions._partition(s, frag, omitFragment, false);
    }

    public static String[] rpartition(String s, String frag) {
        return StringFunctions.rpartition(s, frag, false);
    }

    public static String[] rpartition(String s, String frag, Boolean omitFragment) {
        return StringFunctions._partition(s, frag, omitFragment, true);
    }

    public static String diff(String o1, String o2) {
        return StringUtils.difference((String)o1, (String)o2);
    }

    public static String escape(String s, String mode) {
        String lMode;
        switch (lMode = mode.toLowerCase()) {
            case "html": {
                return StringEscapeUtils.escapeHtml((String)s);
            }
            case "xml": {
                return StringEscapeUtils.escapeXml((String)s);
            }
            case "csv": {
                return StringEscapeUtils.escapeCsv((String)s);
            }
            case "url": {
                return StringFunctions.encodeURIComponent(s);
            }
            case "javascript": {
                return StringEscapeUtils.escapeJavaScript((String)s);
            }
        }
        return s;
    }

    public static String unescape(String valueParameter, String modeParameter) {
        String mode;
        switch (mode = modeParameter.toLowerCase()) {
            case "html": {
                return StringEscapeUtils.unescapeHtml((String)valueParameter);
            }
            case "xml": {
                return StringEscapeUtils.unescapeXml((String)valueParameter);
            }
            case "csv": {
                return StringEscapeUtils.unescapeCsv((String)valueParameter);
            }
            case "url": {
                return StringFunctions.decodeURIComponent(valueParameter);
            }
            case "javascript": {
                return StringEscapeUtils.unescapeJavaScript((String)valueParameter);
            }
        }
        return valueParameter;
    }

    public static String md5(String s) {
        return DigestUtils.md5Hex((String)s);
    }

    public static String sha1(String s) {
        return DigestUtils.sha1Hex((String)s);
    }

    public static String phonetic(String s, String mode) throws EncoderException {
        DoubleMetaphone encoder2;
        switch (mode) {
            case "doublemetaphone": {
                encoder2 = new DoubleMetaphone();
                break;
            }
            case "metaphone": {
                Metaphone encoder2 = new Metaphone();
            }
            case "metaphone3": {
                Metaphone encoder2 = new Metaphone();
            }
            case "soundex": {
                Metaphone encoder2 = new Soundex();
            }
            case "cologne": {
                Metaphone encoder2 = new ColognePhonetic();
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + mode);
            }
        }
        return encoder2.encode((Object)s).toString();
    }

    public static String reinterpret(String s, String encoder) {
        return new String(s.getBytes(), Charset.forName(encoder));
    }

    public static String[] unicode(String s) {
        return (String[])s.chars().mapToObj(c -> Character.valueOf((char)c)).map(c -> StringFunctions.encodeURIComponent(String.valueOf(c))).toArray(String[]::new);
    }

    private static String encodeURIComponent(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return input;
        }
        int l = input.length();
        StringBuilder o = new StringBuilder(l * 3);
        try {
            for (int i = 0; i < l; ++i) {
                String e = input.substring(i, i + 1);
                if (!ALLOWED_CHARS.contains(e)) {
                    Byte[] b = ArrayUtils.toObject((byte[])e.getBytes("utf-8"));
                    o.append(StringFunctions.getHex(b));
                    continue;
                }
                o.append(e);
            }
            return o.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return input;
        }
    }

    private static String decodeURIComponent(String encodedURI) {
        StringBuffer buffer = new StringBuffer();
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < encodedURI.length(); ++i) {
            int bytePattern;
            char actualChar = encodedURI.charAt(i);
            switch (actualChar) {
                case '%': {
                    actualChar = encodedURI.charAt(++i);
                    int hb = (Character.isDigit(actualChar) ? actualChar - 48 : 10 + Character.toLowerCase(actualChar) - 97) & 0xF;
                    actualChar = encodedURI.charAt(++i);
                    int lb = (Character.isDigit(actualChar) ? actualChar - 48 : 10 + Character.toLowerCase(actualChar) - 97) & 0xF;
                    bytePattern = hb << 4 | lb;
                    break;
                }
                case '+': {
                    bytePattern = 32;
                    break;
                }
                default: {
                    bytePattern = actualChar;
                }
            }
            if ((bytePattern & 0xC0) == 128) {
                sumb = sumb << 6 | bytePattern & 0x3F;
                if (--more != 0) continue;
                buffer.append((char)sumb);
                continue;
            }
            if ((bytePattern & 0x80) == 0) {
                buffer.append((char)bytePattern);
                continue;
            }
            if ((bytePattern & 0xE0) == 192) {
                sumb = bytePattern & 0x1F;
                more = 1;
                continue;
            }
            if ((bytePattern & 0xF0) == 224) {
                sumb = bytePattern & 0xF;
                more = 2;
                continue;
            }
            if ((bytePattern & 0xF8) == 240) {
                sumb = bytePattern & 7;
                more = 3;
                continue;
            }
            if ((bytePattern & 0xFC) == 248) {
                sumb = bytePattern & 3;
                more = 4;
                continue;
            }
            sumb = bytePattern & 1;
            more = 5;
        }
        return buffer.toString();
    }

    private static String getHex(Byte[] buf) {
        StringBuilder o = new StringBuilder(buf.length * 3);
        Byte[] byteArray = buf;
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byte b = byteArray[i];
            int n2 = b & 0xFF;
            o.append("%");
            if (n2 < 16) {
                o.append("0");
            }
            o.append(Long.toString(n2, 16).toUpperCase());
        }
        return o.toString();
    }
}

