/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent.functionIntantiation;

import be.ugent.idlab.knows.functions.agent.dataType.ArrayConverter;
import be.ugent.idlab.knows.functions.agent.dataType.CollectionConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterProvider;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.ClassNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.FunctionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.InstantiationException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.MethodNotFoundException;
import be.ugent.idlab.knows.functions.agent.model.Function;
import be.ugent.idlab.knows.functions.agent.model.FunctionMapping;
import be.ugent.idlab.knows.functions.agent.model.Parameter;
import be.ugent.idlab.knows.misc.FileFinder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instantiator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Function> id2functionMap;
    private final Map<String, Method> id2MethodMap = new HashMap<String, Method>();
    private final Map<String, Class<?>> className2ClassMap = new HashMap();
    private final DataTypeConverterProvider dataTypeConverterProvider;

    public Instantiator(Map<String, Function> functions, DataTypeConverterProvider dataTypeConverterProvider) {
        this.id2functionMap = functions;
        this.dataTypeConverterProvider = dataTypeConverterProvider;
    }

    public Method getMethod(String functionId) throws InstantiationException {
        this.logger.debug("Getting instantiation for {}", (Object)functionId);
        if (this.id2MethodMap.containsKey(functionId)) {
            this.logger.debug("Method for {} found in cache.", (Object)functionId);
            return this.id2MethodMap.get(functionId);
        }
        if (this.id2functionMap.containsKey(functionId)) {
            Function function = this.id2functionMap.get(functionId);
            FunctionMapping mapping = function.getFunctionMapping();
            String location = mapping.getImplementation().getLocation();
            String className = mapping.getImplementation().getClassName();
            Class<?> clazz = this.getClass(className, location);
            this.logger.debug("Found class {}", clazz);
            String methodName = mapping.getMethodMapping().getMethodName();
            List<Parameter> parameters = function.getArgumentParameters();
            Method method = null;
            try {
                method = this.getMethod(clazz, methodName, parameters, function.getReturnParameters().get(0));
                this.logger.debug("Found method {}", (Object)method.getName());
                this.id2MethodMap.put(functionId, method);
                return method;
            }
            catch (java.lang.ClassNotFoundException e) {
                throw new ClassNotFoundException(e.getMessage());
            }
        }
        throw new FunctionNotFoundException("No function found with id " + functionId);
    }

    private Class<?> getClass(String className, String location) throws ClassNotFoundException {
        this.logger.debug("Trying to find a Class for {}", (Object)className);
        if (this.className2ClassMap.containsKey(className)) {
            return this.className2ClassMap.get(className);
        }
        try {
            Class<?> cls = Class.forName(className);
            this.className2ClassMap.put(className, cls);
            return cls;
        }
        catch (java.lang.ClassNotFoundException e) {
            this.logger.debug("Class '{}' not found by current class loader. Checking location '{}'", (Object)className, (Object)location);
            URL locationUrl = FileFinder.findFile(location);
            this.logger.debug("Trying to load '{}' for JAR file '{}'", (Object)className, (Object)location);
            try {
                this.loadClassesFromJAR(locationUrl);
                if (this.className2ClassMap.containsKey(className)) {
                    return this.className2ClassMap.get(className);
                }
                this.logger.warn("No class '{}' found in JAR file '{}'", (Object)className, (Object)locationUrl);
            }
            catch (IOException ex) {
                this.logger.warn("An error occurred trying to load classes of file '{}'. Note that only JAR files are supported at the moment.", (Object)locationUrl, (Object)ex);
            }
            throw new ClassNotFoundException("No class found for " + className);
        }
    }

    private Method getMethod(Class<?> clazz, String methodName, List<Parameter> expectedParameters, Parameter expectedReturnParameter) throws MethodNotFoundException, java.lang.ClassNotFoundException {
        Method[] methods;
        this.logger.debug("Trying to find method with name {}", (Object)methodName);
        for (Method method : methods = clazz.getMethods()) {
            boolean qualifies = false;
            if (method.getName().equals(methodName) && method.getParameterCount() == expectedParameters.size()) {
                qualifies = true;
                this.logger.debug("Found method with matching name {} and matching parameter count ({})", (Object)methodName, (Object)expectedParameters.size());
                Type[] parameterTypes = method.getGenericParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Type parameterType = parameterTypes[i];
                    Class<?> methodParameterClass = method.getParameterTypes()[i];
                    DataTypeConverter<?> dataTypeConverter = expectedParameters.get(i).getTypeConverter();
                    if (dataTypeConverter.isSubTypeOf(methodParameterClass)) {
                        if (!dataTypeConverter.getTypeCategory().equals((Object)DataTypeConverter.TypeCategory.COLLECTION)) continue;
                        if (parameterType instanceof ParameterizedType) {
                            ParameterizedType pType = (ParameterizedType)parameterType;
                            Type[] typeArgs = pType.getActualTypeArguments();
                            DataTypeConverter<?> argumentDataTypeConverter = this.dataTypeConverterProvider.getDataTypeConverter(typeArgs[0].getTypeName());
                            ((CollectionConverter)dataTypeConverter).setArgumentTypeConverter(argumentDataTypeConverter);
                            continue;
                        }
                        if (methodParameterClass.isArray()) {
                            Class<?> componentType = methodParameterClass.getComponentType();
                            ArrayConverter arrayConverter = new ArrayConverter();
                            arrayConverter.setArgumentTypeConverter(this.dataTypeConverterProvider.getDataTypeConverter(componentType.getTypeName()));
                            expectedParameters.get(i).setTypeConverter(arrayConverter);
                            continue;
                        }
                        Class<?>[] interfaces = methodParameterClass.getInterfaces();
                        if (Arrays.asList(interfaces).contains(Collection.class)) continue;
                        throw new MethodNotFoundException("No suitable data type converter found for class '" + clazz.getName() + "', method '" + methodName + "', parameter '" + expectedParameters.get(i).getName() + "' which should be of type '" + parameterType.getTypeName() + "'.");
                    }
                    qualifies = false;
                    break;
                }
                Class<?>[] methodParameterTypes = method.getParameterTypes();
                for (int i = 0; i < methodParameterTypes.length; ++i) {
                    Class<?> methodParameterType = methodParameterTypes[i];
                    if (expectedParameters.get(i).getTypeConverter().isSubTypeOf(methodParameterType)) continue;
                    qualifies = false;
                    break;
                }
            }
            if (!qualifies) continue;
            this.logger.debug("Found method by name and expected arguments. Checking return type...");
            Class<?> methodReturnType = method.getReturnType();
            if (expectedReturnParameter.getTypeConverter().isSuperTypeOf(methodReturnType)) {
                this.logger.debug("Found method!");
                return method;
            }
            this.logger.warn("Return type '{}' of method '{}' does not match expeted return type '{}' (class '{}')", new Object[]{methodReturnType.getName(), method.getName(), expectedReturnParameter.getTypeConverter().getTypeClass(), clazz.getName()});
        }
        throw new MethodNotFoundException("No suitable method '" + methodName + "' with matching parameter types found in class '" + clazz.getName() + "'.");
    }

    private void loadClassesFromJAR(URL jarFileUrl) throws IOException {
        try (JarFile jarFile = new JarFile(jarFileUrl.getFile());
             URLClassLoader cl = URLClassLoader.newInstance(new URL[]{jarFileUrl});){
            jarFile.stream().map(ZipEntry::getName).filter(name -> name.endsWith(".class") && !name.contains("$")).map(name -> name.substring(0, name.lastIndexOf(46)).replaceAll("/", ".")).forEach(className -> {
                this.logger.debug("JAR file '{}': found class name '{}'", (Object)jarFileUrl, className);
                if (!this.className2ClassMap.containsKey(className)) {
                    try {
                        Class<?> cls = Class.forName(className, true, cl);
                        this.className2ClassMap.put((String)className, cls);
                    }
                    catch (java.lang.ClassNotFoundException e) {
                        this.logger.warn("Class '{}' in JAR file '{}'", new Object[]{className, jarFileUrl, e});
                    }
                } else {
                    this.logger.debug("Class '{}' already in cache.", className);
                }
            });
        }
    }
}

