/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent.dataType;

import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class DataTypeConverter<T> {
    private Class<?> typeClass;
    private final TypeCategory typeCategory;

    public abstract T convert(Object var1) throws DataTypeConverterException;

    protected DataTypeConverter(Class<T> typeClass, TypeCategory typeCategory) {
        this.typeClass = typeClass;
        this.typeCategory = typeCategory;
    }

    public boolean isSuperTypeOf(Class<?> clazz) {
        Set<String> superclasses = DataTypeConverter.getSuperTypesOf(clazz);
        String className = this.typeClass.isArray() ? "_array" : this.typeClass.getName();
        return superclasses.contains(className);
    }

    public boolean isSubTypeOf(Class<?> clazz) {
        Set<String> superclasses = DataTypeConverter.getSuperTypesOf(this.typeClass);
        String className = clazz.isArray() ? "_array" : clazz.getName();
        return superclasses.contains(className);
    }

    private static Set<String> getSuperTypesOf(Class<?> clazz) {
        Class<?> superclass;
        String classTypeName;
        if (clazz == null) {
            return Collections.emptySet();
        }
        HashSet<Class<Object>> typesToCheck = new HashSet<Class<Object>>(2);
        HashSet<String> superTypes = new HashSet<String>(2);
        switch (classTypeName = clazz.getTypeName()) {
            case "boolean": 
            case "java.lang.Boolean": {
                superTypes.add("boolean");
                superTypes.add("java.lang.Boolean");
                break;
            }
            case "char": 
            case "java.lang.Character": {
                superTypes.add("char");
                superTypes.add("java.lang.Character");
                break;
            }
            case "java.util.List": {
                superTypes.add("java.util.List");
                superTypes.add("_array");
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                superTypes.add("byte");
                superTypes.add("java.lang.Byte");
            }
            case "short": 
            case "java.lang.Short": {
                superTypes.add("short");
                superTypes.add("java.lang.Short");
            }
            case "int": 
            case "java.lang.Integer": {
                superTypes.add("int");
                superTypes.add("java.lang.Integer");
                typesToCheck.add(Float.TYPE);
            }
            case "long": 
            case "java.lang.Long": {
                superTypes.add("long");
                superTypes.add("java.lang.Long");
                typesToCheck.add(Double.TYPE);
                break;
            }
            default: {
                superTypes.add(classTypeName);
            }
        }
        if (clazz.isArray()) {
            superTypes.add("_array");
            typesToCheck.add(List.class);
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            superTypes.addAll(DataTypeConverter.getSuperTypesOf(superclass));
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (Class<?> anInterface : interfaces) {
            superTypes.addAll(DataTypeConverter.getSuperTypesOf(anInterface));
        }
        for (Class clazz2 : typesToCheck) {
            superTypes.addAll(DataTypeConverter.getSuperTypesOf(clazz2));
        }
        return superTypes;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    protected void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    public TypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    public static enum TypeCategory {
        PRIMITIVE,
        COLLECTION,
        OBJECT;

    }
}

