/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.http.server;

import com.github.fmjsjx.libnetty.http.HttpCommonUtil;
import com.github.fmjsjx.libnetty.http.server.HttpRequestContext;
import com.github.fmjsjx.libnetty.http.server.HttpRequestContextHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
class TestHandler
extends HttpRequestContextHandler {
    TestHandler() {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
    }

    protected void messageReceived(ChannelHandlerContext ctx, HttpRequestContext msg) throws Exception {
        System.out.println("-- test --");
        System.out.println(msg);
        System.out.println();
        ByteBuf body = ByteBufUtil.writeUtf8((ByteBufAllocator)ctx.alloc(), (CharSequence)"200 OK");
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(msg.request().protocolVersion(), HttpResponseStatus.OK, body);
        HttpUtil.setContentLength((HttpMessage)res, (long)body.readableBytes());
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)msg.request());
        HttpUtil.setKeepAlive((HttpMessage)res, (boolean)keepAlive);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpCommonUtil.contentType((AsciiString)HttpHeaderValues.TEXT_PLAIN, (Charset)CharsetUtil.UTF_8));
        ChannelFuture future = ctx.writeAndFlush((Object)res);
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

