/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fmjsjx.libnetty.http.server.HttpRequestContext;
import com.github.fmjsjx.libnetty.http.server.HttpResult;
import com.github.fmjsjx.libnetty.http.server.annotation.HeaderValue;
import com.github.fmjsjx.libnetty.http.server.annotation.HttpGet;
import com.github.fmjsjx.libnetty.http.server.annotation.HttpPath;
import com.github.fmjsjx.libnetty.http.server.annotation.HttpPost;
import com.github.fmjsjx.libnetty.http.server.annotation.JsonBody;
import com.github.fmjsjx.libnetty.http.server.annotation.PathVar;
import com.github.fmjsjx.libnetty.http.server.annotation.RemoteAddr;
import com.github.fmjsjx.libnetty.http.server.exception.ManualHttpFailureException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

@HttpPath(value={"/api"})
class TestController {
    TestController() {
    }

    @HttpGet(value={"/test"})
    CompletionStage<HttpResult> getTest(HttpRequestContext ctx) {
        System.out.println("-- test --");
        ByteBuf body = ByteBufUtil.writeAscii((ByteBufAllocator)ctx.alloc(), (CharSequence)"200 OK");
        System.out.println(body.toString(CharsetUtil.UTF_8));
        return ctx.simpleRespond(HttpResponseStatus.OK, body, (CharSequence)HttpHeaderValues.TEXT_PLAIN);
    }

    @HttpGet(value={"/errors/{code}"})
    public CompletionStage<HttpResult> getErrors(HttpRequestContext ctx, @PathVar(value="code") int code, @RemoteAddr String clientIp, @HeaderValue(value="user-agent") Optional<String> userAgent) {
        System.out.println("-- errors --");
        System.out.println("client IP ==> " + clientIp);
        System.out.println("user agent ==> " + userAgent);
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)code);
        System.out.println("status ==> " + status);
        return ctx.simpleRespond(status);
    }

    @HttpGet(value={"/jsons"})
    @JsonBody
    public CompletableFuture<?> getJsons(QueryStringDecoder query, EventLoop eventLoop) {
        System.out.println("-- jsons --");
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        query.parameters().forEach((key, values) -> {
            if (values.size() == 1) {
                node.put(key, (String)values.get(0));
            } else {
                node.putPOJO(key, values);
            }
        });
        return CompletableFuture.supplyAsync(() -> {
            if (node.isEmpty()) {
                throw new ManualHttpFailureException(HttpResponseStatus.BAD_REQUEST, "{\"code\":1,\"message\":\"Missing Query String\"}", (CharSequence)HttpHeaderValues.APPLICATION_JSON, "Missing Query String");
            }
            return node;
        }, (Executor)eventLoop);
    }

    @HttpPost(value={"/echo"})
    public CompletionStage<HttpResult> postEcho(HttpRequestContext ctx, @JsonBody JsonNode value) {
        System.out.println("-- echo --");
        System.out.println("value ==> " + value);
        ByteBuf content = ctx.request().content();
        Charset charset = HttpUtil.getCharset((HttpMessage)ctx.request(), (Charset)CharsetUtil.UTF_8);
        CharSequence contentType = ctx.contentType().orElseGet(() -> com.github.fmjsjx.libnetty.http.HttpUtil.contentType((AsciiString)HttpHeaderValues.TEXT_PLAIN, (Charset)charset));
        return ctx.simpleRespond(HttpResponseStatus.OK, content.retain(), contentType);
    }
}

