/*
 * Decompiled with CFR 0.152.
 */
package flowctrl.integration.slack.webapi.method.channels;

import flowctrl.integration.slack.validation.Problem;
import flowctrl.integration.slack.validation.SlackFieldValidationUtils;
import flowctrl.integration.slack.validation.ValidationError;
import flowctrl.integration.slack.webapi.method.AbstractMethod;
import java.util.List;
import java.util.Map;

public class ChannelCreateMethod
extends AbstractMethod {
    protected String name;

    public ChannelCreateMethod(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getMethodName() {
        return "channels.create";
    }

    @Override
    public void validate(List<ValidationError> errors) {
        if (this.name == null) {
            errors.add(new ValidationError("name", Problem.REQUIRED, null));
        } else if (!SlackFieldValidationUtils.validChannelName(this.name)) {
            errors.add(new ValidationError("name", Problem.PATTERN_NOT_MATCH, "check the link. https://slack.zendesk.com/hc/en-us/articles/201402297-Creating-a-channel"));
        }
    }

    @Override
    protected void createParameters(Map<String, String> parameters) {
        parameters.put("name", this.name);
    }
}

