/*
 * Decompiled with CFR 0.152.
 */
package flowctrl.integration.slack.webapi.method;

import flowctrl.integration.slack.validation.Problem;
import flowctrl.integration.slack.validation.ValidationError;
import flowctrl.integration.slack.webapi.method.AbstractPagingMethod;
import java.util.List;
import java.util.Map;

public abstract class AbstractSearchMethod
extends AbstractPagingMethod {
    protected String query;
    protected String sort;
    protected String sort_dir;
    protected boolean highlight;

    public AbstractSearchMethod(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getSort_dir() {
        return this.sort_dir;
    }

    public void setSort_dir(String sort_dir) {
        this.sort_dir = sort_dir;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    @Override
    public void validate(List<ValidationError> errors) {
        super.validate(errors);
        if (this.query == null) {
            this.addError(errors, "query", Problem.REQUIRED);
        }
        if (this.sort != null && !"timestamp".equalsIgnoreCase(this.sort) && !"score".equalsIgnoreCase(this.sort)) {
            this.addError(errors, "sort", Problem.PATTERN_NOT_MATCH, "\"sort\" must be either \"timestamp\" or \"score\".");
        }
        if (this.sort_dir != null && !"asc".equalsIgnoreCase(this.sort_dir) && !"desc".equalsIgnoreCase(this.sort_dir)) {
            this.addError(errors, "sort_dir", Problem.PATTERN_NOT_MATCH, "\"sort_dir\" must be either \"asc\" or \"desc\".");
        }
    }

    @Override
    protected void createParameters(Map<String, String> parameters) {
        super.createParameters(parameters);
        parameters.put("query", this.query);
        if (this.sort != null) {
            parameters.put("sort", this.sort.toLowerCase());
        }
        if (this.sort_dir != null) {
            parameters.put("sort_dir", this.sort_dir.toLowerCase());
        }
        if (this.isHighlight()) {
            parameters.put("highlight", "1");
        }
    }
}

