/*
 * Decompiled with CFR 0.152.
 */
package flowctrl.integration.slack.bot;

import flowctrl.integration.slack.RestUtils;
import flowctrl.integration.slack.exception.SlackArgumentException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class SlackbotClient {
    private String slackbotUrl;
    private CloseableHttpClient httpClient;

    public SlackbotClient(String slackbotUrl) {
        this(slackbotUrl, 5000);
    }

    public SlackbotClient(String slackbotUrl, int timeout) {
        if (slackbotUrl == null) {
            throw new SlackArgumentException("Missing Slackbot URL Configuration @ SlackApi");
        }
        if (!slackbotUrl.contains(".slack.com/services/hooks/slackbot?token=")) {
            throw new SlackArgumentException("Invalid Service URL. Slackbot URL Format: https://{yourteam}.slack.com/services/hooks/slackbot?token={token}");
        }
        this.slackbotUrl = slackbotUrl;
        this.httpClient = RestUtils.createHttpClient(timeout);
    }

    public void shutdown() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String post(String channel, String message) {
        String url = null;
        try {
            url = this.slackbotUrl + "&channel=" + URLEncoder.encode(channel, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return RestUtils.execute(this.httpClient, url, (HttpEntity)new StringEntity(message, "UTF-8"));
    }
}

