/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.viewanimator;

import android.support.annotation.IntRange;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import com.github.florent37.viewanimator.AnimationBuilder;
import com.github.florent37.viewanimator.AnimationListener;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ValueAnimator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class ViewAnimator {
    private static final long DEFAULT_DURATION = 3000L;
    private List<AnimationBuilder> animationList = new ArrayList<AnimationBuilder>();
    private long duration = 3000L;
    private long startDelay = 0L;
    private Interpolator interpolator = null;
    private int repeatCount = 0;
    private int repeatMode = 1;
    private AnimatorSet animatorSet;
    private View waitForThisViewHeight = null;
    private AnimationListener.Start startListener;
    private AnimationListener.Stop stopListener;
    private ViewAnimator prev = null;
    private ViewAnimator next = null;

    public static AnimationBuilder animate(View ... view) {
        ViewAnimator viewAnimator = new ViewAnimator();
        return viewAnimator.addAnimationBuilder(view);
    }

    public AnimationBuilder thenAnimate(View ... views) {
        ViewAnimator nextViewAnimator;
        this.next = nextViewAnimator = new ViewAnimator();
        nextViewAnimator.prev = this;
        return nextViewAnimator.addAnimationBuilder(views);
    }

    public AnimationBuilder addAnimationBuilder(View ... views) {
        AnimationBuilder animationBuilder = new AnimationBuilder(this, views);
        this.animationList.add(animationBuilder);
        return animationBuilder;
    }

    protected AnimatorSet createAnimatorSet() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        for (AnimationBuilder animationBuilder : this.animationList) {
            animators.addAll(animationBuilder.createAnimators());
        }
        for (AnimationBuilder animationBuilder : this.animationList) {
            if (!animationBuilder.isWaitForHeight()) continue;
            this.waitForThisViewHeight = animationBuilder.getView();
            break;
        }
        for (Animator animator : animators) {
            if (!(animator instanceof ValueAnimator)) continue;
            ValueAnimator valueAnimator = (ValueAnimator)animator;
            valueAnimator.setRepeatCount(this.repeatCount);
            valueAnimator.setRepeatMode(this.repeatMode);
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(animators);
        animatorSet.setDuration(this.duration);
        animatorSet.setStartDelay(this.startDelay);
        if (this.interpolator != null) {
            animatorSet.setInterpolator(this.interpolator);
        }
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (ViewAnimator.this.startListener != null) {
                    ViewAnimator.this.startListener.onStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (ViewAnimator.this.stopListener != null) {
                    ViewAnimator.this.stopListener.onStop();
                }
                if (ViewAnimator.this.next != null) {
                    ViewAnimator.this.next.prev = null;
                    ViewAnimator.this.next.start();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        return animatorSet;
    }

    public ViewAnimator start() {
        if (this.prev != null) {
            this.prev.start();
        } else {
            this.animatorSet = this.createAnimatorSet();
            if (this.waitForThisViewHeight != null) {
                this.waitForThisViewHeight.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        ViewAnimator.this.animatorSet.start();
                        ViewAnimator.this.waitForThisViewHeight.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        return false;
                    }
                });
            } else {
                this.animatorSet.start();
            }
        }
        return this;
    }

    public void cancel() {
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        if (this.next != null) {
            this.next.cancel();
            this.next = null;
        }
    }

    public ViewAnimator duration(long duration) {
        this.duration = duration;
        return this;
    }

    public ViewAnimator startDelay(long startDelay) {
        this.startDelay = startDelay;
        return this;
    }

    public ViewAnimator repeatCount(@IntRange(from=-1L) int repeatCount) {
        this.repeatCount = repeatCount;
        return this;
    }

    public ViewAnimator repeatMode(int repeatMode) {
        this.repeatMode = repeatMode;
        return this;
    }

    public ViewAnimator onStart(AnimationListener.Start startListener) {
        this.startListener = startListener;
        return this;
    }

    public ViewAnimator onStop(AnimationListener.Stop stopListener) {
        this.stopListener = stopListener;
        return this;
    }

    public ViewAnimator interpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RepeatMode {
    }
}

