/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.viewanimator;

import android.graphics.Path;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;

public class SvgPathParser {
    @WorkerThread
    @Nullable
    public static Path tryParsePath(String dAttributeOfPath) {
        try {
            return SvgPathParser.parsePath(dAttributeOfPath);
        }
        catch (Exception e) {
            Log.e(null, (String)"parse svg path error", (Throwable)e);
            return null;
        }
    }

    @WorkerThread
    public static Path parsePath(String dAttributeOfPath) throws Exception {
        int n = dAttributeOfPath.length();
        ParserHelper helper = new ParserHelper(dAttributeOfPath, 0);
        helper.skipWhitespace();
        Path path = new Path();
        float lastX = 0.0f;
        float lastY = 0.0f;
        float lastX1 = 0.0f;
        float lastY1 = 0.0f;
        float subPathStartX = 0.0f;
        float subPathStartY = 0.0f;
        int prevCmd = 0;
        while (helper.getPosition() < n) {
            int cmd = dAttributeOfPath.charAt(helper.getPosition());
            switch (cmd) {
                case 43: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (prevCmd == 109 || prevCmd == 77) {
                        cmd = (char)(prevCmd - 1);
                        break;
                    }
                    if (prevCmd == 99 || prevCmd == 67) {
                        cmd = prevCmd;
                        break;
                    }
                    if (prevCmd == 108 || prevCmd == 76) {
                        cmd = prevCmd;
                        break;
                    }
                }
                default: {
                    helper.advance();
                    prevCmd = cmd;
                }
            }
            boolean wasCurve = false;
            switch (cmd) {
                case 77: 
                case 109: {
                    float x = helper.nextFloat();
                    float y = helper.nextFloat();
                    Log.d(null, (String)String.format("move to: [%s,%s]", Float.valueOf(x), Float.valueOf(y)));
                    if (cmd == 109) {
                        subPathStartX += x;
                        subPathStartY += y;
                        path.rMoveTo(x, y);
                        lastX += x;
                        lastY += y;
                        break;
                    }
                    subPathStartX = x;
                    subPathStartY = y;
                    path.moveTo(x, y);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 90: 
                case 122: {
                    Log.d(null, (String)String.format("close, move to: [%s,%s]", Float.valueOf(subPathStartX), Float.valueOf(subPathStartY)));
                    path.close();
                    path.moveTo(subPathStartX, subPathStartY);
                    lastX = subPathStartX;
                    lastY = subPathStartY;
                    lastX1 = subPathStartX;
                    lastY1 = subPathStartY;
                    wasCurve = true;
                    break;
                }
                case 76: 
                case 108: {
                    float x = helper.nextFloat();
                    float y = helper.nextFloat();
                    Log.d(null, (String)String.format("line to: [%s,%s]", Float.valueOf(x), Float.valueOf(y)));
                    if (cmd == 108) {
                        path.rLineTo(x, y);
                        lastX += x;
                        lastY += y;
                        break;
                    }
                    path.lineTo(x, y);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 72: 
                case 104: {
                    float x = helper.nextFloat();
                    Log.d(null, (String)String.format("horizontal line to: [%s]", Float.valueOf(x)));
                    if (cmd == 104) {
                        path.rLineTo(x, 0.0f);
                        lastX += x;
                        break;
                    }
                    path.lineTo(x, lastY);
                    lastX = x;
                    break;
                }
                case 86: 
                case 118: {
                    float y = helper.nextFloat();
                    Log.d(null, (String)String.format("vertical line to: [%s]", Float.valueOf(y)));
                    if (cmd == 118) {
                        path.rLineTo(0.0f, y);
                        lastY += y;
                        break;
                    }
                    path.lineTo(lastX, y);
                    lastY = y;
                    break;
                }
                case 67: 
                case 99: {
                    wasCurve = true;
                    float x1 = helper.nextFloat();
                    float y1 = helper.nextFloat();
                    float x2 = helper.nextFloat();
                    float y2 = helper.nextFloat();
                    float x = helper.nextFloat();
                    float y = helper.nextFloat();
                    Log.d(null, (String)String.format("cubic to: [%s,%s][%s,%s][%s,%s]", Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x), Float.valueOf(y)));
                    if (cmd == 99) {
                        x1 += lastX;
                        x2 += lastX;
                        x += lastX;
                        y1 += lastY;
                        y2 += lastY;
                        y += lastY;
                    }
                    path.cubicTo(x1, y1, x2, y2, x, y);
                    lastX1 = x2;
                    lastY1 = y2;
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 83: 
                case 115: {
                    wasCurve = true;
                    float x2 = helper.nextFloat();
                    float y2 = helper.nextFloat();
                    float x = helper.nextFloat();
                    float y = helper.nextFloat();
                    Log.d(null, (String)String.format("cubic to: [%s,%s][%s,%s]", Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x), Float.valueOf(y)));
                    if (cmd == 115) {
                        x2 += lastX;
                        x += lastX;
                        y2 += lastY;
                        y += lastY;
                    }
                    float x1 = 2.0f * lastX - lastX1;
                    float y1 = 2.0f * lastY - lastY1;
                    path.cubicTo(x1, y1, x2, y2, x, y);
                    lastX1 = x2;
                    lastY1 = y2;
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 65: 
                case 97: {
                    float rx = helper.nextFloat();
                    float ry = helper.nextFloat();
                    float theta = helper.nextFloat();
                    int largeArc = (int)helper.nextFloat();
                    int sweepArc = (int)helper.nextFloat();
                    float x = helper.nextFloat();
                    float y = helper.nextFloat();
                    Log.d(null, (String)String.format("arc to: [%s,%s][%s][%s,%s][%s,%s]", Float.valueOf(rx), Float.valueOf(ry), Float.valueOf(theta), largeArc, sweepArc, Float.valueOf(x), Float.valueOf(y)));
                    SvgPathParser.drawArc(path, lastX, lastY, x, y, rx, ry, theta, largeArc, sweepArc);
                    lastX = x;
                    lastY = y;
                    break;
                }
            }
            if (!wasCurve) {
                lastX1 = lastX;
                lastY1 = lastY;
            }
            helper.skipWhitespace();
        }
        return path;
    }

    private static void drawArc(Path p, float lastX, float lastY, float x, float y, float rx, float ry, float theta, int largeArc, int sweepArc) {
    }

    private static class ParserHelper {
        private char current;
        private CharSequence s;
        private int position;
        private int length;
        private static final double[] pow10 = new double[128];

        public ParserHelper(CharSequence s, int position) {
            this.s = s;
            this.position = position;
            this.length = s.length();
            this.current = s.charAt(position);
        }

        private char read() {
            if (this.position < this.length) {
                ++this.position;
            }
            if (this.position == this.length) {
                return '\u0000';
            }
            return this.s.charAt(this.position);
        }

        public int getPosition() {
            return this.position;
        }

        public void skipWhitespace() {
            while (this.position < this.length && Character.isWhitespace(this.s.charAt(this.position))) {
                this.advance();
            }
        }

        public void skipNumberSeparator() {
            block3: while (this.position < this.length) {
                char c = this.s.charAt(this.position);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case ' ': 
                    case ',': {
                        this.advance();
                        continue block3;
                    }
                }
                return;
            }
        }

        public void advance() {
            this.current = this.read();
        }

        public float parseFloat() {
            int mant = 0;
            int mantDig = 0;
            boolean mantPos = true;
            boolean mantRead = false;
            int exp = 0;
            int expDig = 0;
            int expAdj = 0;
            boolean expPos = true;
            switch (this.current) {
                case '-': {
                    mantPos = false;
                }
                case '+': {
                    this.current = this.read();
                }
            }
            block4 : switch (this.current) {
                default: {
                    return Float.NaN;
                }
                case '.': {
                    break;
                }
                case '0': {
                    mantRead = true;
                    block50: while (true) {
                        this.current = this.read();
                        switch (this.current) {
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                break block50;
                            }
                            case '.': 
                            case 'E': 
                            case 'e': {
                                break block4;
                            }
                            default: {
                                return 0.0f;
                            }
                            case '0': {
                                continue block50;
                            }
                        }
                        break;
                    }
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    mantRead = true;
                    while (true) {
                        if (mantDig < 9) {
                            ++mantDig;
                            mant = mant * 10 + (this.current - 48);
                        } else {
                            ++expAdj;
                        }
                        this.current = this.read();
                        switch (this.current) {
                            default: {
                                break block4;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                        }
                    }
                }
            }
            if (this.current == '.') {
                this.current = this.read();
                block17 : switch (this.current) {
                    default: {
                        if (mantRead) break;
                        this.reportUnexpectedCharacterError(this.current);
                        return 0.0f;
                    }
                    case '0': {
                        if (mantDig == 0) {
                            block52: while (true) {
                                this.current = this.read();
                                --expAdj;
                                switch (this.current) {
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        break block52;
                                    }
                                    default: {
                                        if (mantRead) break block17;
                                        return 0.0f;
                                    }
                                    case '0': {
                                        continue block52;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        while (true) {
                            if (mantDig < 9) {
                                ++mantDig;
                                mant = mant * 10 + (this.current - 48);
                                --expAdj;
                            }
                            this.current = this.read();
                            switch (this.current) {
                                default: {
                                    break block17;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': 
                            }
                        }
                    }
                }
            }
            block28 : switch (this.current) {
                case 'E': 
                case 'e': {
                    this.current = this.read();
                    switch (this.current) {
                        default: {
                            this.reportUnexpectedCharacterError(this.current);
                            return 0.0f;
                        }
                        case '-': {
                            expPos = false;
                        }
                        case '+': {
                            this.current = this.read();
                            switch (this.current) {
                                default: {
                                    this.reportUnexpectedCharacterError(this.current);
                                    return 0.0f;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': 
                            }
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                    }
                    switch (this.current) {
                        case '0': {
                            block54: while (true) {
                                this.current = this.read();
                                switch (this.current) {
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        break block54;
                                    }
                                    default: {
                                        break block28;
                                    }
                                    case '0': {
                                        continue block54;
                                    }
                                }
                                break;
                            }
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            while (true) {
                                if (expDig < 3) {
                                    ++expDig;
                                    exp = exp * 10 + (this.current - 48);
                                }
                                this.current = this.read();
                                switch (this.current) {
                                    default: {
                                        break block28;
                                    }
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': 
                                }
                            }
                        }
                    }
                }
            }
            if (!expPos) {
                exp = -exp;
            }
            exp += expAdj;
            if (!mantPos) {
                mant = -mant;
            }
            return ParserHelper.buildFloat(mant, exp);
        }

        private void reportUnexpectedCharacterError(char c) {
            throw new RuntimeException("Unexpected char '" + c + "'.");
        }

        public static float buildFloat(int mant, int exp) {
            if (exp < -125 || mant == 0) {
                return 0.0f;
            }
            if (exp >= 128) {
                return mant > 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
            }
            if (exp == 0) {
                return mant;
            }
            if (mant >= 0x4000000) {
                ++mant;
            }
            return (float)(exp > 0 ? (double)mant * pow10[exp] : (double)mant / pow10[-exp]);
        }

        public float nextFloat() {
            this.skipWhitespace();
            float f = this.parseFloat();
            this.skipNumberSeparator();
            return f;
        }

        static {
            for (int i = 0; i < pow10.length; ++i) {
                ParserHelper.pow10[i] = Math.pow(10.0, i);
            }
        }
    }
}

