/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.viewanimator;

import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import com.github.florent37.viewanimator.AnimationBuilder;
import com.github.florent37.viewanimator.AnimationListener;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import java.util.ArrayList;
import java.util.List;

public class ViewAnimator {
    List<AnimationBuilder> animationList = new ArrayList<AnimationBuilder>();
    Long duration = null;
    Long startDelay = null;
    Interpolator interpolator = null;
    AnimatorSet animatorSet;
    View waitForThisViewHeight = null;
    AnimationListener.Start startListener;
    AnimationListener.Stop stopListener;
    ViewAnimator prev = null;
    ViewAnimator next = null;

    public static AnimationBuilder animate(View ... view) {
        ViewAnimator viewAnimator = new ViewAnimator();
        return viewAnimator.addAnimationBuilder(view);
    }

    public AnimationBuilder thenAnimate(View ... views) {
        ViewAnimator nextViewAnimator;
        this.next = nextViewAnimator = new ViewAnimator();
        nextViewAnimator.prev = this;
        return nextViewAnimator.addAnimationBuilder(views);
    }

    public AnimationBuilder addAnimationBuilder(View ... views) {
        AnimationBuilder animationBuilder = new AnimationBuilder(this, views);
        this.animationList.add(animationBuilder);
        return animationBuilder;
    }

    protected AnimatorSet createAnimatorSet() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        for (AnimationBuilder animationBuilder : this.animationList) {
            animators.addAll(animationBuilder.createAnimators());
        }
        for (AnimationBuilder animationBuilder : this.animationList) {
            if (!animationBuilder.isWaitForHeight()) continue;
            this.waitForThisViewHeight = animationBuilder.getView();
            break;
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(animators);
        if (this.duration != null) {
            animatorSet.setDuration(this.duration.longValue());
        }
        if (this.startDelay != null) {
            animatorSet.setDuration(this.startDelay.longValue());
        }
        if (this.interpolator != null) {
            animatorSet.setInterpolator(this.interpolator);
        }
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (ViewAnimator.this.startListener != null) {
                    ViewAnimator.this.startListener.onStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (ViewAnimator.this.stopListener != null) {
                    ViewAnimator.this.stopListener.onStop();
                }
                if (ViewAnimator.this.next != null) {
                    ViewAnimator.this.next.prev = null;
                    ViewAnimator.this.next.start();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        return animatorSet;
    }

    public ViewAnimator start() {
        if (this.prev != null) {
            this.prev.start();
        } else {
            this.animatorSet = this.createAnimatorSet();
            if (this.waitForThisViewHeight != null) {
                this.waitForThisViewHeight.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        ViewAnimator.this.animatorSet.start();
                        ViewAnimator.this.waitForThisViewHeight.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        return false;
                    }
                });
            } else {
                this.animatorSet.start();
            }
        }
        return this;
    }

    public void cancel() {
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        if (this.next != null) {
            this.next.cancel();
            this.next = null;
        }
    }

    public ViewAnimator duration(long duration) {
        this.duration = duration;
        return this;
    }

    public ViewAnimator startDelay(long startDelay) {
        this.startDelay = startDelay;
        return this;
    }

    public ViewAnimator onStart(AnimationListener.Start startListener) {
        this.startListener = startListener;
        return this;
    }

    public ViewAnimator onStop(AnimationListener.Stop stopListener) {
        this.stopListener = stopListener;
        return this;
    }

    public ViewAnimator interpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }
}

