/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelAmPmPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelDayOfMonthPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelDayPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelHourPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelMinutePicker;
import com.github.florent37.singledateandtimepicker.widget.WheelMonthPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelYearPicker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SingleDateAndTimePicker
extends LinearLayout {
    public static final boolean IS_CYCLIC_DEFAULT = true;
    public static final boolean IS_CURVED_DEFAULT = false;
    public static final boolean MUST_BE_ON_FUTUR_DEFAULT = false;
    public static final int DELAY_BEFORE_CHECK_PAST = 200;
    private static final int VISIBLE_ITEM_COUNT_DEFAULT = 7;
    private static final int PM_HOUR_ADDITION = 12;
    private static final CharSequence FORMAT_24_HOUR = "EEE d MMM H:mm";
    private static final CharSequence FORMAT_12_HOUR = "EEE d MMM h:mm a";
    @NonNull
    private final WheelYearPicker yearsPicker;
    @NonNull
    private final WheelMonthPicker monthPicker;
    @NonNull
    private final WheelDayOfMonthPicker daysOfMonthPicker;
    @NonNull
    private final WheelDayPicker daysPicker;
    @NonNull
    private final WheelMinutePicker minutesPicker;
    @NonNull
    private final WheelHourPicker hoursPicker;
    @NonNull
    private final WheelAmPmPicker amPmPicker;
    private List<WheelPicker> pickers = new ArrayList<WheelPicker>();
    private List<OnDateChangedListener> listeners = new ArrayList<OnDateChangedListener>();
    private View dtSelector;
    private boolean mustBeOnFuture;
    @Nullable
    private Date minDate;
    @Nullable
    private Date maxDate;
    @NonNull
    private Date defaultDate = new Date();
    private boolean displayYears = false;
    private boolean displayMonth = false;
    private boolean displayDaysOfMonth = false;
    private boolean displayDays = true;
    private boolean displayMinutes = true;
    private boolean displayHours = true;
    private boolean isAmPm;

    public SingleDateAndTimePicker(Context context) {
        this(context, null);
    }

    public SingleDateAndTimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleDateAndTimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.isAmPm = !DateFormat.is24HourFormat((Context)context);
        SingleDateAndTimePicker.inflate((Context)context, (int)R.layout.single_day_picker, (ViewGroup)this);
        this.yearsPicker = (WheelYearPicker)this.findViewById(R.id.yearPicker);
        this.monthPicker = (WheelMonthPicker)this.findViewById(R.id.monthPicker);
        this.daysOfMonthPicker = (WheelDayOfMonthPicker)this.findViewById(R.id.daysOfMonthPicker);
        this.daysPicker = (WheelDayPicker)this.findViewById(R.id.daysPicker);
        this.minutesPicker = (WheelMinutePicker)this.findViewById(R.id.minutesPicker);
        this.hoursPicker = (WheelHourPicker)this.findViewById(R.id.hoursPicker);
        this.amPmPicker = (WheelAmPmPicker)this.findViewById(R.id.amPmPicker);
        this.dtSelector = this.findViewById(R.id.dtSelector);
        this.pickers.addAll(Arrays.asList(new WheelPicker[]{this.daysPicker, this.minutesPicker, this.hoursPicker, this.amPmPicker, this.daysOfMonthPicker, this.monthPicker, this.yearsPicker}));
        this.init(context, attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.yearsPicker.setOnYearSelectedListener(new WheelYearPicker.OnYearSelectedListener(){

            @Override
            public void onYearSelected(WheelYearPicker picker, int position, int year) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
                if (SingleDateAndTimePicker.this.displayDaysOfMonth) {
                    SingleDateAndTimePicker.this.updateDaysOfMonth();
                }
            }
        });
        this.monthPicker.setOnMonthSelectedListener(new WheelMonthPicker.MonthSelectedListener(){

            @Override
            public void onMonthSelected(WheelMonthPicker picker, int monthIndex, String monthName) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
                if (SingleDateAndTimePicker.this.displayDaysOfMonth) {
                    SingleDateAndTimePicker.this.updateDaysOfMonth();
                }
            }
        });
        this.daysOfMonthPicker.setDayOfMonthSelectedListener(new WheelDayOfMonthPicker.DayOfMonthSelectedListener(){

            @Override
            public void onDayOfMonthSelected(WheelDayOfMonthPicker picker, int dayIndex) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        });
        this.daysOfMonthPicker.setOnFinishedLoopListener(new WheelDayOfMonthPicker.FinishedLoopListener(){

            @Override
            public void onFinishedLoop(WheelDayOfMonthPicker picker) {
                if (SingleDateAndTimePicker.this.displayMonth) {
                    SingleDateAndTimePicker.this.monthPicker.scrollTo(SingleDateAndTimePicker.this.monthPicker.getCurrentItemPosition() + 1);
                    SingleDateAndTimePicker.this.updateDaysOfMonth();
                }
            }
        });
        this.daysPicker.setOnDaySelectedListener(new WheelDayPicker.OnDaySelectedListener(){

            @Override
            public void onDaySelected(WheelDayPicker picker, int position, String name, Date date) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        });
        this.minutesPicker.setOnMinuteChangedListener(new WheelMinutePicker.OnMinuteChangedListener(){

            @Override
            public void onMinuteChanged(WheelMinutePicker picker, int minutes) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        }).setOnFinishedLoopListener(new WheelMinutePicker.OnFinishedLoopListener(){

            @Override
            public void onFinishedLoop(WheelMinutePicker picker) {
                SingleDateAndTimePicker.this.hoursPicker.scrollTo(SingleDateAndTimePicker.this.hoursPicker.getCurrentItemPosition() + 1);
            }
        });
        this.hoursPicker.setOnFinishedLoopListener(new WheelHourPicker.FinishedLoopListener(){

            @Override
            public void onFinishedLoop(WheelHourPicker picker) {
                SingleDateAndTimePicker.this.daysPicker.scrollTo(SingleDateAndTimePicker.this.daysPicker.getCurrentItemPosition() + 1);
            }
        }).setHourChangedListener(new WheelHourPicker.OnHourChangedListener(){

            @Override
            public void onHourChanged(WheelHourPicker picker, int hour) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        });
        this.amPmPicker.setAmPmListener(new WheelAmPmPicker.AmPmListener(){

            @Override
            public void onAmPmChanged(WheelAmPmPicker picker, boolean isAm) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        });
        this.setDefaultDate(this.defaultDate);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (WheelPicker picker : this.pickers) {
            picker.setEnabled(enabled);
        }
    }

    public void setDisplayYears(boolean displayYears) {
        this.displayYears = displayYears;
        this.yearsPicker.setVisibility(displayYears ? 0 : 8);
    }

    public void setDisplayMonths(boolean displayMonths) {
        this.displayMonth = displayMonths;
        this.monthPicker.setVisibility(displayMonths ? 0 : 8);
        this.checkSettings();
    }

    public void setDisplayDaysOfMonth(boolean displayDaysOfMonth) {
        this.displayDaysOfMonth = displayDaysOfMonth;
        this.daysOfMonthPicker.setVisibility(displayDaysOfMonth ? 0 : 8);
        if (displayDaysOfMonth) {
            this.updateDaysOfMonth();
        }
        this.checkSettings();
    }

    public void setDisplayDays(boolean displayDays) {
        this.displayDays = displayDays;
        this.daysPicker.setVisibility(displayDays ? 0 : 8);
        this.checkSettings();
    }

    public void setDisplayMinutes(boolean displayMinutes) {
        this.displayMinutes = displayMinutes;
        this.minutesPicker.setVisibility(displayMinutes ? 0 : 8);
    }

    public void setDisplayHours(boolean displayHours) {
        this.displayHours = displayHours;
        this.hoursPicker.setVisibility(displayHours ? 0 : 8);
        this.setIsAmPm(this.isAmPm);
        this.hoursPicker.setIsAmPm(this.isAmPm);
    }

    public void setDisplayMonthNumbers(boolean displayMonthNumbers) {
        this.monthPicker.setDisplayMonthNumbers(displayMonthNumbers);
        this.monthPicker.updateAdapter();
    }

    public void setTodayText(String todayText) {
        if (todayText != null && !todayText.isEmpty()) {
            this.daysPicker.setTodayText(todayText);
        }
    }

    public void setCurved(boolean curved) {
        for (WheelPicker picker : this.pickers) {
            picker.setCurved(curved);
        }
    }

    public void setCyclic(boolean cyclic) {
        for (WheelPicker picker : this.pickers) {
            picker.setCyclic(cyclic);
        }
    }

    public void setTextSize(int textSize) {
        for (WheelPicker picker : this.pickers) {
            picker.setItemTextSize(textSize);
        }
    }

    public void setSelectedTextColor(int selectedTextColor) {
        for (WheelPicker picker : this.pickers) {
            picker.setSelectedItemTextColor(selectedTextColor);
        }
    }

    public void setTextColor(int textColor) {
        for (WheelPicker picker : this.pickers) {
            picker.setItemTextColor(textColor);
        }
    }

    public void setSelectorColor(int selectorColor) {
        this.dtSelector.setBackgroundColor(selectorColor);
    }

    public void setSelectorHeight(int selectorHeight) {
        ViewGroup.LayoutParams dtSelectorLayoutParams = this.dtSelector.getLayoutParams();
        dtSelectorLayoutParams.height = selectorHeight;
        this.dtSelector.setLayoutParams(dtSelectorLayoutParams);
    }

    public void setVisibleItemCount(int visibleItemCount) {
        for (WheelPicker picker : this.pickers) {
            picker.setVisibleItemCount(visibleItemCount);
        }
    }

    public void setIsAmPm(boolean isAmPm) {
        this.isAmPm = isAmPm;
        this.amPmPicker.setVisibility(isAmPm && this.displayHours ? 0 : 8);
        this.hoursPicker.setIsAmPm(isAmPm);
    }

    public void setDayFormatter(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.daysPicker.setDayFormatter(simpleDateFormat);
        }
    }

    public boolean isAmPm() {
        return this.isAmPm;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
        this.setMinYear();
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
        this.setMinYear();
    }

    private void checkMinMaxDate(WheelPicker picker) {
        this.checkBeforeMinDate(picker);
        this.checkAfterMaxDate(picker);
    }

    private void checkBeforeMinDate(WheelPicker picker) {
        picker.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SingleDateAndTimePicker.this.minDate != null && SingleDateAndTimePicker.this.isBeforeMinDate(SingleDateAndTimePicker.this.getDate())) {
                    for (WheelPicker p : SingleDateAndTimePicker.this.pickers) {
                        p.scrollTo(p.findIndexOfDate(SingleDateAndTimePicker.this.minDate));
                    }
                }
            }
        }, 200L);
    }

    private void checkAfterMaxDate(WheelPicker picker) {
        picker.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SingleDateAndTimePicker.this.maxDate != null && SingleDateAndTimePicker.this.isAfterMaxDate(SingleDateAndTimePicker.this.getDate())) {
                    for (WheelPicker p : SingleDateAndTimePicker.this.pickers) {
                        p.scrollTo(p.findIndexOfDate(SingleDateAndTimePicker.this.maxDate));
                    }
                }
            }
        }, 200L);
    }

    private boolean isBeforeMinDate(Date date) {
        return DateHelper.getCalendarOfDate(date).before(DateHelper.getCalendarOfDate(this.minDate));
    }

    private boolean isAfterMaxDate(Date date) {
        return DateHelper.getCalendarOfDate(date).after(DateHelper.getCalendarOfDate(this.maxDate));
    }

    public void addOnDateChangedListener(OnDateChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeOnDateChangedListener(OnDateChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void checkPickersMinMax() {
        for (WheelPicker picker : this.pickers) {
            this.checkMinMaxDate(picker);
        }
    }

    public Date getDate() {
        int hour = this.hoursPicker.getCurrentHour();
        if (this.isAmPm && this.amPmPicker.isPm()) {
            hour += 12;
        }
        int minute = this.minutesPicker.getCurrentMinute();
        Calendar calendar = Calendar.getInstance();
        if (this.displayDays) {
            Date dayDate = this.daysPicker.getCurrentDate();
            calendar.setTime(dayDate);
        } else {
            if (this.displayMonth) {
                calendar.set(2, this.monthPicker.getCurrentMonth());
            }
            if (this.displayYears) {
                calendar.set(1, this.yearsPicker.getCurrentYear());
            }
            if (this.displayDaysOfMonth) {
                int daysInMonth = calendar.getActualMaximum(5);
                if (this.daysOfMonthPicker.getCurrentDay() >= daysInMonth) {
                    calendar.set(5, daysInMonth);
                } else {
                    calendar.set(5, this.daysOfMonthPicker.getCurrentDay() + 1);
                }
            }
        }
        calendar.set(11, hour);
        calendar.set(12, minute);
        return calendar.getTime();
    }

    public void setStepMinutes(int minutesStep) {
        this.minutesPicker.setStepMinutes(minutesStep);
    }

    public void setHoursStep(int hoursStep) {
        this.hoursPicker.setHoursStep(hoursStep);
    }

    public void setDefaultDate(Date date) {
        if (date != null) {
            this.defaultDate = date;
            for (WheelPicker picker : this.pickers) {
                picker.setDefaultDate(this.defaultDate);
            }
        }
    }

    public void selectDate(Calendar calendar) {
        if (calendar == null) {
            return;
        }
        Date date = calendar.getTime();
        for (WheelPicker picker : this.pickers) {
            picker.selectDate(date);
        }
        if (this.displayDaysOfMonth) {
            this.updateDaysOfMonth();
        }
    }

    private void updateListener() {
        Date date = this.getDate();
        CharSequence format = this.isAmPm ? FORMAT_12_HOUR : FORMAT_24_HOUR;
        String displayed = DateFormat.format((CharSequence)format, (Date)date).toString();
        for (OnDateChangedListener listener : this.listeners) {
            listener.onDateChanged(displayed, date);
        }
    }

    private void updateDaysOfMonth() {
        Date date = this.getDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.updateDaysOfMonth(calendar);
    }

    private void updateDaysOfMonth(@NonNull Calendar calendar) {
        int daysInMonth = calendar.getActualMaximum(5);
        this.daysOfMonthPicker.setDaysInMonth(daysInMonth);
        this.daysOfMonthPicker.updateAdapter();
    }

    public void setMustBeOnFuture(boolean mustBeOnFuture) {
        this.mustBeOnFuture = mustBeOnFuture;
        if (mustBeOnFuture) {
            this.minDate = Calendar.getInstance().getTime();
        }
    }

    public boolean mustBeOnFuture() {
        return this.mustBeOnFuture;
    }

    private void setMinYear() {
        if (this.displayYears && this.minDate != null && this.maxDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.minDate);
            this.yearsPicker.setMinYear(calendar.get(1));
            calendar.setTime(this.maxDate);
            this.yearsPicker.setMaxYear(calendar.get(1));
        }
    }

    private void checkSettings() {
        if (this.displayDays && (this.displayDaysOfMonth || this.displayMonth)) {
            throw new IllegalArgumentException("You can either display days with months or days and months separately");
        }
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SingleDateAndTimePicker);
        Resources resources = this.getResources();
        this.setTodayText(a.getString(R.styleable.SingleDateAndTimePicker_picker_todayText));
        this.setTextColor(a.getColor(R.styleable.SingleDateAndTimePicker_picker_textColor, ContextCompat.getColor((Context)context, (int)R.color.picker_default_text_color)));
        this.setSelectedTextColor(a.getColor(R.styleable.SingleDateAndTimePicker_picker_selectedTextColor, ContextCompat.getColor((Context)context, (int)R.color.picker_default_selected_text_color)));
        this.setSelectorColor(a.getColor(R.styleable.SingleDateAndTimePicker_picker_selectorColor, ContextCompat.getColor((Context)context, (int)R.color.picker_default_selector_color)));
        this.setSelectorHeight(a.getDimensionPixelSize(R.styleable.SingleDateAndTimePicker_picker_selectorHeight, resources.getDimensionPixelSize(R.dimen.wheelSelectorHeight)));
        this.setTextSize(a.getDimensionPixelSize(R.styleable.SingleDateAndTimePicker_picker_textSize, resources.getDimensionPixelSize(R.dimen.WheelItemTextSize)));
        this.setCurved(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_curved, false));
        this.setCyclic(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_cyclic, true));
        this.setMustBeOnFuture(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_mustBeOnFuture, false));
        this.setVisibleItemCount(a.getInt(R.styleable.SingleDateAndTimePicker_picker_visibleItemCount, 7));
        this.setDisplayDays(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayDays, this.displayDays));
        this.setDisplayMinutes(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayMinutes, this.displayMinutes));
        this.setDisplayHours(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayHours, this.displayHours));
        this.setDisplayMonths(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayMonth, this.displayMonth));
        this.setDisplayYears(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayYears, this.displayYears));
        this.setDisplayDaysOfMonth(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayDaysOfMonth, this.displayDaysOfMonth));
        this.setDisplayMonthNumbers(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayMonthNumbers, this.monthPicker.displayMonthNumbers()));
        this.checkSettings();
        this.setMinYear();
        a.recycle();
        if (this.displayDaysOfMonth) {
            this.updateDaysOfMonth(Calendar.getInstance());
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(String var1, Date var2);
    }
}

