/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class WheelYearPicker
extends WheelPicker<String> {
    private SimpleDateFormat simpleDateFormat;
    protected int minYear;
    protected int maxYear;
    private OnYearSelectedListener onYearSelectedListener;

    public WheelYearPicker(Context context) {
        super(context);
    }

    public WheelYearPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
        this.simpleDateFormat = new SimpleDateFormat("yyyy", this.getCurrentLocale());
        Calendar instance = Calendar.getInstance();
        int currentYear = instance.get(1);
        this.minYear = currentYear - 20;
        this.maxYear = currentYear + 20;
    }

    @Override
    protected String initDefault() {
        return this.getTodayText();
    }

    @NonNull
    private String getTodayText() {
        return this.getResources().getString(R.string.picker_today);
    }

    @Override
    protected void onItemSelected(int position, String item) {
        if (this.onYearSelectedListener != null) {
            int year = this.convertItemToYear(position);
            this.onYearSelectedListener.onYearSelected(this, position, year);
        }
    }

    public void setMaxYear(int maxYear) {
        this.maxYear = maxYear;
        this.notifyDatasetChanged();
    }

    public void setMinYear(int minYear) {
        this.minYear = minYear;
        this.notifyDatasetChanged();
    }

    @Override
    protected List<String> generateAdapterValues() {
        ArrayList<String> years = new ArrayList<String>();
        Calendar instance = Calendar.getInstance();
        instance.set(1, this.minYear - 1);
        for (int i = this.minYear; i <= this.maxYear; ++i) {
            instance.add(1, 1);
            years.add(this.getFormattedValue(instance.getTime()));
        }
        return years;
    }

    @Override
    protected String getFormattedValue(Object value) {
        return this.simpleDateFormat.format(value);
    }

    public void setOnYearSelectedListener(OnYearSelectedListener onYearSelectedListener) {
        this.onYearSelectedListener = onYearSelectedListener;
    }

    public int getCurrentYear() {
        return this.convertItemToYear(super.getCurrentItemPosition());
    }

    private int convertItemToYear(int itemPosition) {
        return this.minYear + itemPosition;
    }

    public static interface OnYearSelectedListener {
        public void onYearSelected(WheelYearPicker var1, int var2, int var3);
    }
}

