/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class WheelMonthPicker
extends WheelPicker<String> {
    private int lastScrollPosition;
    private MonthSelectedListener listener;
    private boolean displayMonthNumbers = false;

    public WheelMonthPicker(Context context) {
        this(context, null);
    }

    public WheelMonthPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
    }

    @Override
    protected List<String> generateAdapterValues() {
        ArrayList<String> monthList = new ArrayList<String>();
        SimpleDateFormat month_date = new SimpleDateFormat("MMMM", Locale.getDefault());
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        for (int i = 0; i < 12; ++i) {
            cal.set(2, i);
            if (this.displayMonthNumbers) {
                monthList.add(String.format("%02d", i + 1));
                continue;
            }
            monthList.add(month_date.format(cal.getTime()));
        }
        return monthList;
    }

    @Override
    protected String initDefault() {
        return String.valueOf(DateHelper.getMonth(DateHelper.today()));
    }

    public void setOnMonthSelectedListener(MonthSelectedListener listener) {
        this.listener = listener;
    }

    @Override
    protected void onItemSelected(int position, String item) {
        if (this.listener != null) {
            this.listener.onMonthSelected(this, position, item);
        }
    }

    @Override
    protected void onItemCurrentScroll(int position, String item) {
        if (this.lastScrollPosition != position) {
            this.onItemSelected(position, item);
            this.lastScrollPosition = position;
        }
    }

    public boolean displayMonthNumbers() {
        return this.displayMonthNumbers;
    }

    public void setDisplayMonthNumbers(boolean displayMonthNumbers) {
        this.displayMonthNumbers = displayMonthNumbers;
    }

    public int getCurrentMonth() {
        return this.getCurrentItemPosition();
    }

    public static interface MonthSelectedListener {
        public void onMonthSelected(WheelMonthPicker var1, int var2, String var3);
    }
}

