/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.dialog;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.github.florent37.singledateandtimepicker.R;

public class BottomSheetHelper {
    private Context context;
    private int layoutId;
    private View view;
    private Listener listener;
    private Handler handler;
    private WindowManager windowManager;

    public BottomSheetHelper(Context context, int layoutId) {
        this.context = context;
        this.layoutId = layoutId;
        this.handler = new Handler(Looper.getMainLooper());
    }

    private void init() {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (BottomSheetHelper.this.context instanceof Activity) {
                    BottomSheetHelper.this.windowManager = (WindowManager)BottomSheetHelper.this.context.getSystemService("window");
                    BottomSheetHelper.this.view = LayoutInflater.from((Context)BottomSheetHelper.this.context).inflate(BottomSheetHelper.this.layoutId, null, true);
                    WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(-1, -1, 1000, 8, -3);
                    if ((layoutParams.softInputMode & 0x100) == 0) {
                        WindowManager.LayoutParams nl = new WindowManager.LayoutParams();
                        nl.copyFrom(layoutParams);
                        nl.softInputMode |= 0x100;
                        layoutParams = nl;
                    }
                    BottomSheetHelper.this.windowManager.addView(BottomSheetHelper.this.view, (ViewGroup.LayoutParams)layoutParams);
                    BottomSheetHelper.this.view.findViewById(R.id.bottom_sheet_background).setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            BottomSheetHelper.this.hide();
                        }
                    });
                    if (BottomSheetHelper.this.listener != null) {
                        BottomSheetHelper.this.listener.onLoaded(BottomSheetHelper.this.view);
                    }
                }
            }
        }, 100L);
    }

    public BottomSheetHelper setListener(Listener listener) {
        this.listener = listener;
        return this;
    }

    public void display() {
        this.init();
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)BottomSheetHelper.this.view, (Property)View.TRANSLATION_Y, (float[])new float[]{BottomSheetHelper.this.view.getHeight(), 0.0f});
                objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        if (BottomSheetHelper.this.listener != null) {
                            BottomSheetHelper.this.listener.onOpen();
                        }
                    }
                });
                objectAnimator.start();
            }
        }, 200L);
    }

    public void hide() {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)BottomSheetHelper.this.view, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, BottomSheetHelper.this.view.getHeight()});
                objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        BottomSheetHelper.this.view.setVisibility(8);
                        if (BottomSheetHelper.this.listener != null) {
                            BottomSheetHelper.this.listener.onClose();
                        }
                        BottomSheetHelper.this.remove();
                    }
                });
                objectAnimator.start();
            }
        }, 200L);
    }

    public void dismiss() {
        this.remove();
    }

    private void remove() {
        if (this.view.getWindowToken() != null) {
            this.windowManager.removeView(this.view);
        }
    }

    public static interface Listener {
        public void onOpen();

        public void onLoaded(View var1);

        public void onClose();
    }
}

