/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class WheelHourPicker
extends WheelPicker {
    public static final int MIN_HOUR_DEFAULT = 0;
    public static final int MAX_HOUR_DEFAULT = 23;
    public static final int MAX_HOUR_AM_PM = 12;
    public static final int STEP_HOURS_DEFAULT = 1;
    private OnHourSelectedListener hoursSelectedListener;
    private int defaultHour;
    private int minHour = 0;
    private int maxHour = 23;
    private int hoursStep = 1;
    private int lastScrollPosition;
    protected boolean isAmPm = false;
    private WheelPicker.Adapter adapter;

    public WheelHourPicker(Context context) {
        this(context, null);
    }

    public WheelHourPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAdapter();
    }

    private void initAdapter() {
        int hour;
        ArrayList<String> hours = new ArrayList<String>();
        if (this.isAmPm) {
            hours.add(this.getFormattedValue(12));
            for (hour = this.hoursStep; hour < this.maxHour; hour += this.hoursStep) {
                hours.add(this.getFormattedValue(hour));
            }
        } else {
            for (hour = this.minHour; hour <= this.maxHour; hour += this.hoursStep) {
                hours.add(this.getFormattedValue(hour));
            }
        }
        this.adapter = new WheelPicker.Adapter(hours);
        this.setAdapter(this.adapter);
        Calendar calendar = Calendar.getInstance();
        this.defaultHour = calendar.get(11);
        if (this.isAmPm && this.defaultHour >= 12) {
            this.defaultHour -= 12;
        }
        this.updateDefaultHour();
    }

    @Override
    protected void onItemSelected(int position, Object item) {
        if (this.hoursSelectedListener != null) {
            this.hoursSelectedListener.onHourSelected(this, position, this.convertItemToHour(item));
        }
    }

    @Override
    protected void onItemCurrentScroll(int position, Object item) {
        if (this.hoursSelectedListener != null) {
            this.hoursSelectedListener.onHourCurrentScrolled(this, position, this.convertItemToHour(item));
        }
        if (this.lastScrollPosition != position) {
            this.hoursSelectedListener.onHourCurrentScrolled(this, position, this.convertItemToHour(item));
            if (this.lastScrollPosition == 23 && position == 0 && this.hoursSelectedListener != null) {
                this.hoursSelectedListener.onHourCurrentNewDay(this);
            }
            this.lastScrollPosition = position;
        }
    }

    @Override
    public int findIndexOfDate(@NonNull Date date) {
        int hours;
        if (this.isAmPm && (hours = date.getHours()) >= 12) {
            Date copy = new Date(date.getTime());
            copy.setHours(hours % 12);
            return super.findIndexOfDate(copy);
        }
        return super.findIndexOfDate(date);
    }

    @Override
    protected String getFormattedValue(Object value) {
        Object valueItem = value;
        if (value instanceof Date) {
            Calendar instance = Calendar.getInstance();
            instance.setTime((Date)value);
            valueItem = instance.get(11);
        }
        return String.format(this.getCurrentLocale(), "%1$02d", valueItem);
    }

    private void updateDefaultHour() {
        this.setSelectedItemPosition(this.defaultHour);
    }

    @Override
    public int getDefaultItemPosition() {
        return this.defaultHour;
    }

    public void setOnHourSelectedListener(OnHourSelectedListener hoursSelectedListener) {
        this.hoursSelectedListener = hoursSelectedListener;
    }

    public void setDefaultHour(int hour) {
        if (this.isAmPm && hour >= 12) {
            hour -= 12;
        }
        this.defaultHour = hour;
        this.updateDefaultHour();
    }

    public void setIsAmPm(boolean isAmPm) {
        this.isAmPm = isAmPm;
        if (isAmPm) {
            this.setMaxHour(12);
        } else {
            this.setMaxHour(23);
        }
    }

    public void setMaxHour(int maxHour) {
        if (maxHour >= 0 && maxHour <= 23) {
            this.maxHour = maxHour;
        }
        this.initAdapter();
    }

    public void setMinHour(int minHour) {
        if (minHour >= 0 && minHour <= 23) {
            this.minHour = minHour;
        }
        this.initAdapter();
    }

    public void setHoursStep(int hourStep) {
        if (this.hoursStep >= 0 && this.hoursStep <= 23) {
            this.hoursStep = this.hoursStep;
        }
        this.initAdapter();
    }

    private int convertItemToHour(Object item) {
        Integer hour = Integer.valueOf(String.valueOf(item));
        if (!this.isAmPm) {
            return hour;
        }
        if (hour == 12) {
            hour = 0;
        }
        return hour;
    }

    public int getCurrentHour() {
        return this.convertItemToHour(this.adapter.getItem(this.getCurrentItemPosition()));
    }

    public static interface OnHourSelectedListener {
        public void onHourSelected(WheelHourPicker var1, int var2, int var3);

        public void onHourCurrentScrolled(WheelHourPicker var1, int var2, int var3);

        public void onHourCurrentNewDay(WheelHourPicker var1);
    }
}

