/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelAmPmPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelDayPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelHourPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelMinutePicker;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class SingleDateAndTimePicker
extends LinearLayout {
    public static final boolean IS_CYCLIC_DEFAULT = true;
    public static final boolean IS_CURVED_DEFAULT = false;
    public static final boolean MUST_BE_ON_FUTUR_DEFAULT = false;
    public static final int DELAY_BEFORE_CHECK_PAST = 200;
    private static final int VISIBLE_ITEM_COUNT_DEFAULT = 7;
    private static final int PM_HOUR_ADDITION = 12;
    private static final CharSequence FORMAT_24_HOUR = "EEE d MMM H:mm";
    private static final CharSequence FORMAT_12_HOUR = "EEE d MMM h:mm a";
    private WheelDayPicker daysPicker;
    private WheelMinutePicker minutesPicker;
    private WheelHourPicker hoursPicker;
    private WheelAmPmPicker amPmPicker;
    private Listener listener;
    private int textColor;
    private int selectedTextColor;
    private int textSize;
    private int selectorColor;
    private boolean isCyclic;
    private boolean isCurved;
    private int visibleItemCount;
    private View dtSelector;
    private boolean mustBeOnFuture;
    private Date minDate;
    private Date maxDate;
    private boolean isAmPm;
    private int selectorHeight;

    public SingleDateAndTimePicker(Context context) {
        this(context, null);
    }

    public SingleDateAndTimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleDateAndTimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
        SingleDateAndTimePicker.inflate((Context)context, (int)R.layout.single_day_picker, (ViewGroup)this);
        this.isAmPm = !DateFormat.is24HourFormat((Context)context);
        this.daysPicker = (WheelDayPicker)this.findViewById(R.id.daysPicker);
        this.minutesPicker = (WheelMinutePicker)this.findViewById(R.id.minutesPicker);
        this.hoursPicker = (WheelHourPicker)this.findViewById(R.id.hoursPicker);
        this.amPmPicker = (WheelAmPmPicker)this.findViewById(R.id.amPmPicker);
        this.dtSelector = this.findViewById(R.id.dtSelector);
        ViewGroup.LayoutParams dtSelectorLayoutParams = this.dtSelector.getLayoutParams();
        dtSelectorLayoutParams.height = this.selectorHeight;
        this.dtSelector.setLayoutParams(dtSelectorLayoutParams);
        this.daysPicker.setOnDaySelectedListener(new WheelDayPicker.OnDaySelectedListener(){

            @Override
            public void onDaySelected(WheelDayPicker picker, int position, String name, Date date) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        });
        this.minutesPicker.setOnMinuteSelectedListener(new WheelMinutePicker.OnMinuteSelectedListener(){

            @Override
            public void onMinuteSelected(WheelMinutePicker picker, int position, int minutes) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }

            @Override
            public void onMinuteCurrentScrolled(WheelMinutePicker picker, int position, int minutes) {
            }

            @Override
            public void onMinuteScrolledNewHour(WheelMinutePicker picker) {
                SingleDateAndTimePicker.this.hoursPicker.scrollTo(SingleDateAndTimePicker.this.hoursPicker.getCurrentItemPosition() + 1);
            }
        });
        this.hoursPicker.setOnHourSelectedListener(new WheelHourPicker.OnHourSelectedListener(){

            @Override
            public void onHourSelected(WheelHourPicker picker, int position, int hours) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }

            @Override
            public void onHourCurrentScrolled(WheelHourPicker picker, int position, int hours) {
            }

            @Override
            public void onHourCurrentNewDay(WheelHourPicker picker) {
                SingleDateAndTimePicker.this.daysPicker.scrollTo(SingleDateAndTimePicker.this.daysPicker.getCurrentItemPosition() + 1);
            }
        });
        this.amPmPicker.setOnAmPmSelectedListener(new WheelAmPmPicker.OnAmPmSelectedListener(){

            @Override
            public void onAmSelected(WheelAmPmPicker picker) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }

            @Override
            public void onPmSelected(WheelAmPmPicker picker) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        });
        this.updatePicker();
        this.updateViews();
    }

    public void setCurved(boolean curved) {
        this.isCurved = curved;
        this.updatePicker();
    }

    public void setCyclic(boolean cyclic) {
        this.isCyclic = cyclic;
        this.updatePicker();
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        this.updatePicker();
    }

    public void setSelectedTextColor(int selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
        this.updatePicker();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.updatePicker();
    }

    public void setSelectorColor(int selectorColor) {
        this.selectorColor = selectorColor;
        this.updateViews();
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.visibleItemCount = visibleItemCount;
        this.updatePicker();
    }

    public void setIsAmPm(boolean isAmPm) {
        this.isAmPm = isAmPm;
        this.updateViews();
        this.updatePicker();
    }

    public boolean isAmPm() {
        return this.isAmPm;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    private void updatePicker() {
        if (this.daysPicker != null && this.minutesPicker != null && this.hoursPicker != null && this.amPmPicker != null) {
            for (WheelPicker wheelPicker : Arrays.asList(new WheelPicker[]{this.daysPicker, this.minutesPicker, this.hoursPicker, this.amPmPicker})) {
                wheelPicker.setItemTextColor(this.textColor);
                wheelPicker.setSelectedItemTextColor(this.selectedTextColor);
                wheelPicker.setItemTextSize(this.textSize);
                wheelPicker.setVisibleItemCount(this.visibleItemCount);
                wheelPicker.setCurved(this.isCurved);
                if (wheelPicker == this.amPmPicker) continue;
                wheelPicker.setCyclic(this.isCyclic);
            }
        }
        if (this.amPmPicker != null) {
            this.amPmPicker.setVisibility(this.isAmPm ? 0 : 8);
        }
        if (this.hoursPicker != null) {
            this.hoursPicker.setIsAmPm(this.isAmPm);
        }
    }

    private void updateViews() {
        this.dtSelector.setBackgroundColor(this.selectorColor);
    }

    private void checkMinMaxDate(WheelPicker picker) {
        this.checkBeforeMinDate(picker);
        this.checkAfterMaxDate(picker);
    }

    private void checkBeforeMinDate(WheelPicker picker) {
        picker.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SingleDateAndTimePicker.this.minDate != null && SingleDateAndTimePicker.this.isBeforeMinDate(SingleDateAndTimePicker.this.getDate())) {
                    SingleDateAndTimePicker.this.daysPicker.scrollTo(SingleDateAndTimePicker.this.daysPicker.findIndexOfDate(SingleDateAndTimePicker.this.minDate));
                    SingleDateAndTimePicker.this.minutesPicker.scrollTo(SingleDateAndTimePicker.this.minutesPicker.findIndexOfDate(SingleDateAndTimePicker.this.minDate));
                    SingleDateAndTimePicker.this.hoursPicker.scrollTo(SingleDateAndTimePicker.this.hoursPicker.findIndexOfDate(SingleDateAndTimePicker.this.minDate));
                }
            }
        }, 200L);
    }

    private void checkAfterMaxDate(WheelPicker picker) {
        picker.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SingleDateAndTimePicker.this.maxDate != null && SingleDateAndTimePicker.this.isAfterMaxDate(SingleDateAndTimePicker.this.getDate())) {
                    SingleDateAndTimePicker.this.daysPicker.scrollTo(SingleDateAndTimePicker.this.daysPicker.findIndexOfDate(SingleDateAndTimePicker.this.maxDate));
                    SingleDateAndTimePicker.this.minutesPicker.scrollTo(SingleDateAndTimePicker.this.minutesPicker.findIndexOfDate(SingleDateAndTimePicker.this.maxDate));
                    SingleDateAndTimePicker.this.hoursPicker.scrollTo(SingleDateAndTimePicker.this.hoursPicker.findIndexOfDate(SingleDateAndTimePicker.this.maxDate));
                }
            }
        }, 200L);
    }

    private boolean isBeforeMinDate(Date date) {
        Calendar minDateCalendar = Calendar.getInstance();
        minDateCalendar.setTime(this.minDate);
        minDateCalendar.set(14, 0);
        minDateCalendar.set(13, 0);
        Calendar dateCalendar = Calendar.getInstance();
        dateCalendar.setTime(date);
        dateCalendar.set(14, 0);
        dateCalendar.set(13, 0);
        return dateCalendar.before(minDateCalendar);
    }

    private boolean isAfterMaxDate(Date date) {
        Calendar maxDateCalendar = Calendar.getInstance();
        maxDateCalendar.setTime(this.maxDate);
        maxDateCalendar.set(14, 0);
        maxDateCalendar.set(13, 0);
        Calendar dateCalendar = Calendar.getInstance();
        dateCalendar.setTime(date);
        dateCalendar.set(14, 0);
        dateCalendar.set(13, 0);
        return dateCalendar.after(maxDateCalendar);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public Date getDate() {
        int hour = this.hoursPicker.getCurrentHour();
        if (this.isAmPm && this.amPmPicker.isPm()) {
            hour += 12;
        }
        int minute = this.minutesPicker.getCurrentMinute();
        Calendar calendar = Calendar.getInstance();
        Date dayDate = this.daysPicker.getCurrentDate();
        calendar.setTime(dayDate);
        calendar.set(11, hour);
        calendar.set(12, minute);
        Date time = calendar.getTime();
        return time;
    }

    public void setStepMinutes(int minutesStep) {
        this.minutesPicker.setStepMinutes(minutesStep);
    }

    public void setHoursStep(int hoursStep) {
        this.hoursPicker.setHoursStep(hoursStep);
    }

    public void selectDate(Calendar calendar) {
        int indexOfMin;
        int indexOfHour;
        if (calendar == null) {
            return;
        }
        Date date = calendar.getTime();
        int indexOfDay = this.daysPicker.findIndexOfDate(date);
        if (indexOfDay != -1) {
            this.daysPicker.setSelectedItemPosition(indexOfDay);
        }
        if ((indexOfHour = this.hoursPicker.findIndexOfDate(date)) != -1) {
            if (this.isAmPm) {
                if (calendar.get(11) >= 12) {
                    this.amPmPicker.setPmSelected();
                } else {
                    this.amPmPicker.setAmSelected();
                }
            }
            this.hoursPicker.setSelectedItemPosition(indexOfHour);
        }
        if ((indexOfMin = this.minutesPicker.findIndexOfDate(date)) != -1) {
            this.minutesPicker.setSelectedItemPosition(indexOfMin);
        }
    }

    private void updateListener() {
        Date date = this.getDate();
        CharSequence format = this.isAmPm ? FORMAT_12_HOUR : FORMAT_24_HOUR;
        String displayed = DateFormat.format((CharSequence)format, (Date)date).toString();
        if (this.listener != null) {
            this.listener.onDateChanged(displayed, date);
        }
    }

    public void setMustBeOnFuture(boolean mustBeOnFuture) {
        this.mustBeOnFuture = mustBeOnFuture;
        if (mustBeOnFuture) {
            this.minDate = Calendar.getInstance().getTime();
        }
    }

    public boolean mustBeOnFuture() {
        return this.mustBeOnFuture;
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SingleDateAndTimePicker);
        Resources resources = this.getResources();
        this.textColor = a.getColor(R.styleable.SingleDateAndTimePicker_picker_textColor, resources.getColor(R.color.picker_default_text_color));
        this.selectedTextColor = a.getColor(R.styleable.SingleDateAndTimePicker_picker_selectedTextColor, resources.getColor(R.color.picker_default_selected_text_color));
        this.selectorColor = a.getColor(R.styleable.SingleDateAndTimePicker_picker_selectorColor, resources.getColor(R.color.picker_default_selector_color));
        this.selectorHeight = a.getDimensionPixelSize(R.styleable.SingleDateAndTimePicker_picker_selectorHeight, resources.getDimensionPixelSize(R.dimen.wheelSelectorHeight));
        this.textSize = a.getDimensionPixelSize(R.styleable.SingleDateAndTimePicker_picker_textSize, resources.getDimensionPixelSize(R.dimen.WheelItemTextSize));
        this.isCurved = a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_curved, false);
        this.isCyclic = a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_cyclic, true);
        this.mustBeOnFuture = a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_mustBeOnFuture, false);
        this.visibleItemCount = a.getInt(R.styleable.SingleDateAndTimePicker_picker_visibleItemCount, 7);
        a.recycle();
    }

    public static interface Listener {
        public void onDateChanged(String var1, Date var2);
    }
}

