/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.ArrayList;
import java.util.Calendar;

public class WheelMinutePicker
extends WheelPicker {
    public static final int MIN_MINUTES = 0;
    public static final int MAX_MINUTES = 55;
    public static final int STEP_MINUTES = 5;
    private int defaultMinute;
    private WheelPicker.Adapter adapter;
    int lastScrollPosition;
    private OnMinuteSelectedListener onMinuteSelectedListener;

    public WheelMinutePicker(Context context) {
        this(context, null);
    }

    public WheelMinutePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        String format = "%1$02d";
        ArrayList<String> minutes = new ArrayList<String>();
        for (int min = 0; min <= 55; min += 5) {
            minutes.add(String.format("%1$02d", min));
        }
        this.adapter = new WheelPicker.Adapter(minutes);
        this.setAdapter(this.adapter);
        this.defaultMinute = Calendar.getInstance().get(12);
        this.updateDefaultMinute();
    }

    public void setOnMinuteSelectedListener(OnMinuteSelectedListener onMinuteSelectedListener) {
        this.onMinuteSelectedListener = onMinuteSelectedListener;
    }

    @Override
    protected void onItemSelected(int position, Object item) {
        if (this.onMinuteSelectedListener != null) {
            this.onMinuteSelectedListener.onMinuteSelected(this, position, this.convertItemToMinute(item));
        }
    }

    @Override
    protected void onItemCurrentScroll(int position, Object item) {
        if (this.lastScrollPosition != position) {
            this.onMinuteSelectedListener.onMinuteCurrentScrolled(this, position, this.convertItemToMinute(item));
            if (this.lastScrollPosition == 11 && position == 0 && this.onMinuteSelectedListener != null) {
                this.onMinuteSelectedListener.onMinuteScrolledNewHour(this);
            }
            this.lastScrollPosition = position;
        }
    }

    private int findIndexOfMinute(int minute) {
        int itemCount = this.adapter.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            String object = this.adapter.getItemText(i);
            Integer value = Integer.valueOf(object);
            if (minute >= value) continue;
            return i - 1;
        }
        return 0;
    }

    private void updateDefaultMinute() {
        this.setSelectedItemPosition(this.findIndexOfMinute(this.defaultMinute));
    }

    public void setDefaultMinute(int minutes) {
        this.defaultMinute = minutes;
        this.updateDefaultMinute();
    }

    @Override
    public int getDefaultItemPosition() {
        return this.findIndexOfMinute(this.defaultMinute);
    }

    private int convertItemToMinute(Object item) {
        return Integer.valueOf(String.valueOf(item));
    }

    public int getCurrentMinute() {
        return this.convertItemToMinute(this.adapter.getItem(this.getCurrentItemPosition()));
    }

    public static interface OnMinuteSelectedListener {
        public void onMinuteSelected(WheelMinutePicker var1, int var2, int var3);

        public void onMinuteCurrentScrolled(WheelMinutePicker var1, int var2, int var3);

        public void onMinuteScrolledNewHour(WheelMinutePicker var1);
    }
}

