/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.content.res.AppCompatResources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.manager.ClipManager;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class ShapeOfView
extends FrameLayout {
    private final Paint clipPaint = new Paint(1);
    private final Path clipPath = new Path();
    protected PorterDuffXfermode pdMode;
    @Nullable
    protected Drawable drawable = null;
    private ClipManager clipManager = new ClipPathManager();
    private boolean requiersShapeUpdate = true;
    private Bitmap clipBitmap;

    public ShapeOfView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public ShapeOfView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ShapeOfView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void setBackground(Drawable background) {
    }

    public void setBackgroundResource(int resid) {
    }

    public void setBackgroundColor(int color) {
    }

    private void init(Context context, AttributeSet attrs) {
        this.clipPaint.setAntiAlias(true);
        this.clipPaint.setColor(-1);
        this.setDrawingCacheEnabled(true);
        this.setLayerType(1, this.clipPaint);
        this.pdMode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
        this.setWillNotDraw(false);
        this.clipPaint.setColor(-16777216);
        this.clipPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.clipPaint.setStrokeWidth(1.0f);
        if (attrs != null) {
            int resourceId;
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.ShapeOfView);
            if (attributes.hasValue(R.styleable.ShapeOfView_shape_clip_drawable) && -1 != (resourceId = attributes.getResourceId(R.styleable.ShapeOfView_shape_clip_drawable, -1))) {
                this.setDrawable(resourceId);
            }
            attributes.recycle();
        }
    }

    protected int dpToPx(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.requiresShapeUpdate();
        }
    }

    private boolean requiresBitmap() {
        return this.isInEditMode() || this.clipManager != null && this.clipManager.requiresBitmap() || this.drawable != null;
    }

    public void setDrawable(Drawable drawable) {
        this.drawable = drawable;
        this.requiresShapeUpdate();
    }

    public void setDrawable(int redId) {
        this.setDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)redId));
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.requiersShapeUpdate) {
            this.calculateLayout(canvas.getWidth(), canvas.getHeight());
            this.requiersShapeUpdate = false;
        }
        this.clipPaint.setXfermode((Xfermode)this.pdMode);
        if (this.requiresBitmap()) {
            canvas.drawBitmap(this.clipBitmap, 0.0f, 0.0f, this.clipPaint);
        } else {
            canvas.drawPath(this.clipPath, this.clipPaint);
        }
        this.clipPaint.setXfermode(null);
        this.setLayerType(2, null);
    }

    private void calculateLayout(int width, int height) {
        if (this.clipManager != null && width > 0 && height > 0) {
            this.clipManager.setupClipLayout(width, height);
            this.clipPath.reset();
            this.clipPath.set(this.clipManager.createMask(width, height));
            if (this.requiresBitmap()) {
                if (this.clipBitmap != null) {
                    this.clipBitmap.recycle();
                }
                this.clipBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(this.clipBitmap);
                if (this.drawable != null) {
                    this.drawable.setBounds(0, 0, width, height);
                    this.drawable.draw(canvas);
                } else {
                    canvas.drawPath(this.clipPath, this.clipManager.getPaint());
                }
            }
            if (Build.VERSION.SDK_INT >= 21 && ViewCompat.getElevation((View)this) > 0.0f) {
                try {
                    this.setOutlineProvider(this.getOutlineProvider());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.postInvalidate();
    }

    @TargetApi(value=21)
    public ViewOutlineProvider getOutlineProvider() {
        return new ViewOutlineProvider(){

            public void getOutline(View view, Outline outline) {
                Path shadowConvexPath;
                if (ShapeOfView.this.clipManager != null && (shadowConvexPath = ShapeOfView.this.clipManager.getShadowConvexPath()) != null) {
                    try {
                        outline.setConvexPath(shadowConvexPath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public void setClipPathCreator(ClipPathManager.ClipPathCreator createClipPath) {
        ((ClipPathManager)this.clipManager).setClipPathCreator(createClipPath);
        this.requiresShapeUpdate();
    }

    public void requiresShapeUpdate() {
        this.requiersShapeUpdate = true;
        this.postInvalidate();
    }
}

