/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class TriangleView
extends ShapeOfView {
    private float percentBottom = 0.5f;
    private float percentLeft = 0.0f;
    private float percentRight = 0.0f;

    public TriangleView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public TriangleView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public TriangleView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.TriangleView);
            this.percentBottom = attributes.getFloat(R.styleable.TriangleView_shape_triangle_percentBottom, this.percentBottom);
            this.percentLeft = attributes.getFloat(R.styleable.TriangleView_shape_triangle_percentLeft, this.percentLeft);
            this.percentRight = attributes.getFloat(R.styleable.TriangleView_shape_triangle_percentRight, this.percentRight);
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                Path path = new Path();
                path.moveTo(0.0f, TriangleView.this.percentLeft * (float)height);
                path.lineTo(TriangleView.this.percentBottom * (float)width, (float)height);
                path.lineTo((float)width, TriangleView.this.percentRight * (float)height);
                path.close();
                return path;
            }
        });
    }

    public float getPercentBottom() {
        return this.percentBottom;
    }

    public void setPercentBottom(float percentBottom) {
        this.percentBottom = percentBottom;
        this.postInvalidate();
    }

    public float getPercentLeft() {
        return this.percentLeft;
    }

    public void setPercentLeft(float percentLeft) {
        this.percentLeft = percentLeft;
        this.postInvalidate();
    }

    public float getPercentRight() {
        return this.percentRight;
    }

    public void setPercentRight(float percentRight) {
        this.percentRight = percentRight;
        this.postInvalidate();
    }
}

