/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class RoundRectView
extends ShapeOfView {
    private final RectF rectF = new RectF();
    private int topLeftRadius;
    private int topRightRadius;
    private int bottomRightRadius;
    private int bottomLeftRadius;
    private final Paint borderPaint = new Paint(1);
    private final RectF borderRectF = new RectF();
    private final Path borderPath = new Path();
    @ColorInt
    private int borderColor = -1;
    private int borderWidthPx = 0;

    public RoundRectView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public RoundRectView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RoundRectView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.RoundRectView);
            this.topLeftRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_topLeftRadius, this.topLeftRadius);
            this.topRightRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_topRightRadius, this.topRightRadius);
            this.bottomLeftRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_bottomLeftRadius, this.bottomLeftRadius);
            this.bottomRightRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_bottomRightRadius, this.bottomRightRadius);
            this.borderColor = attributes.getColor(R.styleable.RoundRectView_shape_roundRect_borderColor, this.borderColor);
            this.borderWidthPx = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_borderWidth, this.borderWidthPx);
            attributes.recycle();
        }
        this.borderPaint.setStyle(Paint.Style.STROKE);
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                RoundRectView.this.rectF.set(0.0f, 0.0f, (float)width, (float)height);
                return RoundRectView.this.generatePath(RoundRectView.this.rectF, RoundRectView.this.limitSize(RoundRectView.this.topLeftRadius, width, height), RoundRectView.this.limitSize(RoundRectView.this.topRightRadius, width, height), RoundRectView.this.limitSize(RoundRectView.this.bottomRightRadius, width, height), RoundRectView.this.limitSize(RoundRectView.this.bottomLeftRadius, width, height));
            }
        });
    }

    protected float limitSize(float from, float width, float height) {
        return Math.min(from, Math.min(width, height));
    }

    public void invalidate() {
        super.invalidate();
        this.borderRectF.set((float)this.borderWidthPx / 2.0f, (float)this.borderWidthPx / 2.0f, (float)this.getWidth() - (float)this.borderWidthPx / 2.0f, (float)this.getHeight() - (float)this.borderWidthPx / 2.0f);
        this.borderPath.set(this.generatePath(this.borderRectF, this.topLeftRadius, this.topRightRadius, this.bottomRightRadius, this.bottomLeftRadius));
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.borderWidthPx > 0) {
            this.borderPaint.setStrokeWidth((float)this.borderWidthPx);
            this.borderPaint.setColor(this.borderColor);
            canvas.drawPath(this.borderPath, this.borderPaint);
        }
    }

    private Path generatePath(RectF rect, float topLeftRadius, float topRightRadius, float bottomRightRadius, float bottomLeftRadius) {
        return this.generatePath(true, rect, topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius);
    }

    private Path generatePath(boolean useBezier, RectF rect, float topLeftRadius, float topRightRadius, float bottomRightRadius, float bottomLeftRadius) {
        Path path = new Path();
        float left = rect.left;
        float top = rect.top;
        float bottom = rect.bottom;
        float right = rect.right;
        float minSize = Math.min(rect.width() / 2.0f, rect.height() / 2.0f);
        topLeftRadius = topLeftRadius < 0.0f ? 0.0f : topLeftRadius;
        topRightRadius = topRightRadius < 0.0f ? 0.0f : topRightRadius;
        bottomLeftRadius = bottomLeftRadius < 0.0f ? 0.0f : bottomLeftRadius;
        float f = bottomRightRadius = bottomRightRadius < 0.0f ? 0.0f : bottomRightRadius;
        if (topLeftRadius > minSize) {
            topLeftRadius = minSize;
        }
        if (topRightRadius > minSize) {
            topRightRadius = minSize;
        }
        if (bottomLeftRadius > minSize) {
            bottomLeftRadius = minSize;
        }
        if (bottomRightRadius > minSize) {
            bottomRightRadius = minSize;
        }
        path.moveTo(left + topLeftRadius, top);
        path.lineTo(right - topRightRadius, top);
        if (useBezier) {
            path.quadTo(right, top, right, top + topRightRadius);
        } else {
            path.arcTo(new RectF(right - topRightRadius * 2.0f, top, right, top + topRightRadius * 2.0f), -90.0f, 90.0f);
        }
        path.lineTo(right, bottom - bottomRightRadius);
        if (useBezier) {
            path.quadTo(right, bottom, right - bottomRightRadius, bottom);
        } else {
            path.arcTo(new RectF(right - bottomRightRadius * 2.0f, bottom - bottomRightRadius * 2.0f, right, bottom), 0.0f, 90.0f);
        }
        path.lineTo(left + bottomLeftRadius, bottom);
        if (useBezier) {
            path.quadTo(left, bottom, left, bottom - bottomLeftRadius);
        } else {
            path.arcTo(new RectF(left, bottom - bottomLeftRadius * 2.0f, left + bottomLeftRadius * 2.0f, bottom), 90.0f, 90.0f);
        }
        path.lineTo(left, top + topLeftRadius);
        if (useBezier) {
            path.quadTo(left, top, left + topLeftRadius, top);
        } else {
            path.arcTo(new RectF(left, top, left + topLeftRadius * 2.0f, top + topLeftRadius * 2.0f), 180.0f, 90.0f);
        }
        path.close();
        return path;
    }

    public int getTopLeftRadius() {
        return this.topLeftRadius;
    }

    public void setTopLeftRadius(int topLeftRadius) {
        this.topLeftRadius = topLeftRadius;
        this.postInvalidate();
    }

    public int getTopRightRadius() {
        return this.topRightRadius;
    }

    public void setTopRightRadius(int topRightRadius) {
        this.topRightRadius = topRightRadius;
        this.postInvalidate();
    }

    public int getBottomRightRadius() {
        return this.bottomRightRadius;
    }

    public void setBottomRightRadius(int bottomRightRadius) {
        this.bottomRightRadius = bottomRightRadius;
        this.postInvalidate();
    }

    public int getBottomLeftRadius() {
        return this.bottomLeftRadius;
    }

    public void setBottomLeftRadius(int bottomLeftRadius) {
        this.bottomLeftRadius = bottomLeftRadius;
        this.postInvalidate();
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.postInvalidate();
    }

    public int getBorderWidthPx() {
        return this.borderWidthPx;
    }

    public void setBorderWidthPx(int borderWidthPx) {
        this.borderWidthPx = borderWidthPx;
        this.postInvalidate();
    }
}

