/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.content.res.AppCompatResources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.manager.ClipDrawableManager;
import com.github.florent37.shapeofview.manager.ClipManager;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class ShapeOfView
extends FrameLayout {
    private ClipManager clipManager = null;
    private final Paint clipPaint = new Paint(1);
    protected PorterDuffXfermode pdMode;
    protected Bitmap mask;

    public ShapeOfView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public ShapeOfView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ShapeOfView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.clipPaint.setAntiAlias(true);
        this.clipPaint.setColor(-1);
        this.setDrawingCacheEnabled(true);
        this.setLayerType(1, null);
        this.pdMode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
        this.setWillNotDraw(false);
        this.clipPaint.setColor(-16777216);
        this.clipPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.clipPaint.setStrokeWidth(1.0f);
        if (attrs != null) {
            int resourceId;
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.ShapeOfView);
            if (attributes.hasValue(R.styleable.ShapeOfView_clip_drawable) && -1 != (resourceId = attributes.getResourceId(R.styleable.ShapeOfView_clip_drawable, -1))) {
                this.setDrawable(resourceId);
            }
            attributes.recycle();
        }
    }

    protected int dpToPx(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.calculateLayout();
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.clipPaint.setXfermode((Xfermode)this.pdMode);
        canvas.drawBitmap(this.mask, 0.0f, 0.0f, this.clipPaint);
        this.clipPaint.setXfermode(null);
    }

    private void calculateLayout() {
        if (this.clipManager != null) {
            int height = this.getMeasuredHeight();
            int width = this.getMeasuredWidth();
            if (width > 0 && height > 0) {
                if (this.mask != null && !this.mask.isRecycled()) {
                    this.mask.recycle();
                }
                if (this.clipManager != null) {
                    this.clipManager.setupClipLayout(width, height);
                    this.mask = this.clipManager.createMask(width, height);
                }
                if (Build.VERSION.SDK_INT >= 21 && ViewCompat.getElevation((View)this) > 0.0f) {
                    try {
                        this.setOutlineProvider(this.getOutlineProvider());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.postInvalidate();
    }

    @TargetApi(value=21)
    public ViewOutlineProvider getOutlineProvider() {
        return new ViewOutlineProvider(){

            public void getOutline(View view, Outline outline) {
                Path shadowConvexPath;
                if (ShapeOfView.this.clipManager != null && (shadowConvexPath = ShapeOfView.this.clipManager.getShadowConvexPath()) != null) {
                    try {
                        outline.setConvexPath(shadowConvexPath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public void setClipPathCreator(ClipPathManager.ClipPathCreator createClipPath) {
        if (!(this.clipManager instanceof ClipPathManager)) {
            this.clipManager = new ClipPathManager();
        }
        ((ClipPathManager)this.clipManager).setClipPathCreator(createClipPath);
    }

    public void setDrawable(Drawable drawable) {
        if (!(this.clipManager instanceof ClipDrawableManager)) {
            this.clipManager = new ClipDrawableManager();
        }
        ((ClipDrawableManager)this.clipManager).setDrawable(drawable);
    }

    public void setDrawable(int redId) {
        this.setDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)redId));
    }
}

