/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.runtimepermission;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import java.util.ArrayList;
import java.util.List;

public class PermissionFragment
extends Fragment {
    public static final String LIST_PERMISSIONS = "LIST_PERMISSIONS";
    private static final int REQUEST_CODE = 23;
    private List<String> permissionsList = new ArrayList<String>();
    @Nullable
    private PermissionListener listener;

    public PermissionFragment() {
        this.setRetainInstance(true);
    }

    public static PermissionFragment newInstance(List<String> permissions) {
        Bundle args = new Bundle();
        args.putStringArrayList(LIST_PERMISSIONS, new ArrayList<String>(permissions));
        PermissionFragment fragment = new PermissionFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        ArrayList permissionsArgs;
        super.onCreate(savedInstanceState);
        Bundle arguments = this.getArguments();
        if (arguments != null && (permissionsArgs = arguments.getStringArrayList(LIST_PERMISSIONS)) != null) {
            this.permissionsList.addAll(permissionsArgs);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.permissionsList.size() > 0) {
            String[] perms = new String[this.permissionsList.size()];
            this.permissionsList.toArray(perms);
            this.requestPermissions(perms, 23);
        } else {
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 23 && permissions.length > 0 && this.listener != null) {
            PermissionListener listener = this.listener;
            ArrayList<String> acceptedPermissions = new ArrayList<String>();
            ArrayList<String> askAgainPermissions = new ArrayList<String>();
            ArrayList<String> refusedPermissions = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                String permissionName = permissions[i];
                if (grantResults[i] == 0) {
                    acceptedPermissions.add(permissionName);
                    continue;
                }
                if (this.shouldShowRequestPermissionRationale(permissionName)) {
                    askAgainPermissions.add(permissionName);
                    continue;
                }
                refusedPermissions.add(permissionName);
            }
            listener.onRequestPermissionsResult(acceptedPermissions, refusedPermissions, askAgainPermissions);
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
    }

    public PermissionFragment setListener(@Nullable PermissionListener listener) {
        this.listener = listener;
        return this;
    }

    static interface PermissionListener {
        public void onRequestPermissionsResult(List<String> var1, List<String> var2, List<String> var3);
    }
}

